/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.contributors.AbstractXmlDocumentArtefactAnalyser;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import com.springsource.bundlor.util.ClassNameUtils;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WebApplicationArtifactAnalyzer
extends AbstractXmlDocumentArtefactAnalyser {
    private static final String WEB_XML_LOCATION = "WEB-INF/web.xml";
    private static final String XPATH_EXPRESSION = "//context-param/param-value | //filter/filter-class | //filter/init-param/param-value | //listener/listener-class | //servlet/servlet-class | //servlet/init-param/param-value | //error-page/exception-type | //env-entry/env-entry-type | //ejb-ref/home | //ejb-ref/remote | //ejb-local-ref/local-home | //ejb-local-ref/local | //service-ref/service-interface | //resource-ref/res-type | //resource-env-ref/resource-env-ref-type | //message-destination-ref/message-destination-type";
    private final XPathExpression expression;

    public WebApplicationArtifactAnalyzer() {
        super(false);
        try {
            XPathFactory newInstance = XPathFactory.newInstance();
            XPath xpath = newInstance.newXPath();
            this.expression = xpath.compile(XPATH_EXPRESSION);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void analyse(Document doc, String artefactName, PartialManifest partialManifest) throws Exception {
        NodeList nodes = (NodeList)this.expression.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            String candidateType = element.getTextContent().trim();
            if (ClassNameUtils.isValidFqn(candidateType)) {
                partialManifest.recordReferencedType(candidateType);
            }
            ++i;
        }
    }

    public boolean canAnalyse(String artefactName) {
        return artefactName.endsWith(WEB_XML_LOCATION);
    }
}

