/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.ManifestModifier;
import com.springsource.bundlor.support.ManifestReader;
import com.springsource.bundlor.support.TemplateHeaderReader;
import com.springsource.bundlor.util.SimpleParserLogger;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import com.springsource.util.osgi.manifest.parse.HeaderParserFactory;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IgnoredExistingHeadersManifestModifier
implements ManifestModifier,
ManifestReader,
TemplateHeaderReader {
    private static final String ATTR_IGNORED_EXISTING_HEADERS = "Ignored-Existing-Headers";
    private final List<String> ignoredExistingHeaders = new ArrayList<String>();
    private final Object ignoredExistingHeadersMonitor = new Object();

    @Override
    public void readJarManifest(ManifestContents manifest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readManifestTemplate(ManifestContents manifestTemplate) {
        Object object = this.ignoredExistingHeadersMonitor;
        synchronized (object) {
            String value = manifestTemplate.getMainAttributes().get(ATTR_IGNORED_EXISTING_HEADERS);
            List<HeaderDeclaration> headers = this.parseTemplate(value);
            for (HeaderDeclaration header : headers) {
                this.ignoredExistingHeaders.add(header.getNames().get(0));
            }
        }
    }

    @Override
    public void modify(ManifestContents manifest) {
        for (String ignoredExistingHeader : this.ignoredExistingHeaders) {
            Pattern pattern = Pattern.compile(ignoredExistingHeader.replace("*", ".*"));
            Map<String, String> attributes = manifest.getMainAttributes();
            Iterator<String> i = attributes.keySet().iterator();
            while (i.hasNext()) {
                String header = i.next();
                if (!pattern.matcher(header).matches()) continue;
                i.remove();
            }
        }
    }

    @Override
    public List<String> getTemplateOnlyHeaderNames() {
        return Arrays.asList(ATTR_IGNORED_EXISTING_HEADERS);
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser(new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }
}

