/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.contributors.AbstractXmlDocumentArtefactAnalyser;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import com.springsource.bundlor.util.ClassNameUtils;
import com.springsource.util.math.Sets;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class HibernateMappingArtefactAnalyser
extends AbstractXmlDocumentArtefactAnalyser {
    private static final Set<String> BASIC_HIBERNATE_TYPES = Sets.asSet("integer", "long", "short", "float", "double", "character", "byte", "boolean", "yes_no", "true_false", "string", "date", "time", "timestamp", "calendar", "calendar_date", "big_decimal", "big_integer", "locale", "timezone", "currency", "class", "binary", "text", "serializable", "clob", "blob", "imm_date", "imm_time", "imm_timestamp", "imm_calendar", "imm_calendar_date", "imm_serializable", "imm_binary");
    private static final Set<String> GENERATOR_TYPES = Sets.asSet("increment", "identity", "sequence", "hilo", "seqhilo", "uuid", "guid", "native", "assigned", "select", "foreign", "sequence-identity");
    private final XPathExpression packageExpression;
    private final XPathExpression tagExpression;

    public HibernateMappingArtefactAnalyser() {
        super(false);
        try {
            XPathFactory newInstance = XPathFactory.newInstance();
            XPath xpath = newInstance.newXPath();
            this.packageExpression = xpath.compile("//hibernate-mapping/@package");
            this.tagExpression = xpath.compile("//class/@name | //id/@type | //generator/@class | //composite-id/@class | //discriminator/@type | //version/@type | //property/@type | //many-to-one/@class | //one-to-one/@class | //one-to-many/@class | //many-to-many/@class | //component/@class | //dynamic-component/@class | //subclass/@name | //joined-subclass/@name | //union-subclass/@name | //import/@class");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void analyse(Document doc, String artefactName, PartialManifest partialManifest) throws Exception {
        String packagePrefix = this.getPackagePrefix(doc);
        NodeList nodes = (NodeList)this.tagExpression.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodes.getLength()) {
            String candidateType;
            Attr attribute = (Attr)nodes.item(i);
            String value = attribute.getValue();
            if (!BASIC_HIBERNATE_TYPES.contains(value) && !GENERATOR_TYPES.contains(value) && ClassNameUtils.isValidFqn(candidateType = value.contains(".") ? value.trim() : String.valueOf(packagePrefix) + "." + value.trim())) {
                partialManifest.recordReferencedType(candidateType);
            }
            ++i;
        }
    }

    public boolean canAnalyse(String artefactName) {
        return artefactName.endsWith(".hbm");
    }

    private String getPackagePrefix(Document doc) {
        NodeList nodes;
        block4: {
            try {
                nodes = (NodeList)this.packageExpression.evaluate(doc, XPathConstants.NODESET);
                if (nodes.getLength() >= 1) break block4;
                return "";
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        if (nodes.getLength() > 1) {
            throw new RuntimeException("Found more than one package attribute in file");
        }
        return ((Attr)nodes.item(0)).getValue();
    }
}

