/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.impl;

import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.view.web.WebRootFileUrl;
import com.intellij.javaee.module.view.web.WebView;
import com.intellij.javaee.web.artifact.WebFacetContextEvaluationService;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDirectoryElementImpl
extends PsiElementBase
implements WebDirectoryElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.impl.WebDirectoryElementImpl");
    private final PsiManager myManager;
    private final WebFacet myWebFacet;
    private String myPath;
    private boolean myIsDirectory;
    private final WebFacetContextEvaluationService myWebFacetContextService;

    public WebDirectoryElementImpl(WebFacet webFacet, @NotNull String path, boolean isDirectory) {
        if (path == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(0);
        }
        this.myWebFacet = webFacet;
        String canonicalPath = PathUtil.getCanonicalPath((String)path);
        this.myPath = DeploymentUtil.appendToPath((String)"/", (String)(canonicalPath == null ? path : canonicalPath));
        this.myManager = PsiManager.getInstance((Project)webFacet.getModule().getProject());
        this.myIsDirectory = isDirectory;
        this.myWebFacetContextService = WebFacetContextEvaluationService.getInstance(this.myManager.getProject());
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @NotNull
    public List<VirtualFile> getOriginalVirtualFiles() {
        Module module = this.myWebFacet.getModule();
        if (module.isDisposed()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                WebDirectoryElementImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<VirtualFile> list = this.myWebFacetContextService.getOutputFiles(this.myWebFacet, this.myPath);
        if (list == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public VirtualFile getOriginalVirtualFile() {
        List<VirtualFile> originalVirtualFiles = this.getOriginalVirtualFiles();
        if (originalVirtualFiles.size() >= 1) {
            return originalVirtualFiles.get(0);
        }
        return null;
    }

    public PsiFile getOriginalFile() {
        VirtualFile virtualFile = this.getOriginalVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return this.myManager.findFile(virtualFile);
    }

    @NotNull
    public String getName() {
        int lastSeparatorIndex = this.getPath().lastIndexOf(47);
        if (lastSeparatorIndex >= 0) {
            String string = this.getPath().substring(lastSeparatorIndex + 1);
            if (string == null) {
                WebDirectoryElementImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.getPath();
        if (string == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private String getParentPath() {
        if (this.getPath().equals("/")) {
            return null;
        }
        return this.getPath().substring(0, this.getPath().lastIndexOf(47));
    }

    public boolean isWritable() {
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile virtualFile : virtualFiles) {
            if (virtualFile.isWritable()) continue;
            return false;
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(6);
        }
    }

    public boolean isValid() {
        return this.myManager != null && WebDirectoryUtil.getWebDirectoryUtil(this.myManager.getProject()).findWebDirectoryElementByPath(this.getPath(), this.myWebFacet) != null;
    }

    @Nullable
    public WebDirectoryElement getParent() {
        if ("/".equals(this.getPath())) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(this.myManager.getProject()).findWebDirectoryElementByPath(this.getParentPath(), this.myWebFacet);
    }

    public WebDirectoryElement getParentDirectory() {
        return this.getParent();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.getOriginalVirtualFile();
    }

    @Nullable
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(7);
        }
        this.checkSetName(name);
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) continue;
            directory.setName(name);
        }
        String parentPath = this.getParentPath();
        String newPath = parentPath == null ? name : DeploymentUtil.appendToPath((String)parentPath, (String)name);
        newPath = DeploymentUtil.appendToPath((String)"/", (String)newPath);
        return WebDirectoryUtil.resolveAbsolutePath(newPath, this.myWebFacet);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) continue;
            directory.checkSetName(name);
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdFileTypes.JAVA.getLanguage();
        if (language == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(8);
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public WebDirectoryElement[] getChildren() {
        if (!this.isDirectory()) {
            if (WebDirectoryElement.EMPTY_ARRAY == null) {
                WebDirectoryElementImpl.$$$reportNull$$$0(9);
            }
            return WebDirectoryElement.EMPTY_ARRAY;
        }
        THashSet children = new THashSet();
        this.processChildren(new WebDirectoryElement.WebDirectoryProcessor((Set)children){
            final /* synthetic */ Set val$children;
            {
                this.val$children = set;
            }

            public boolean execute(String name, boolean isDirectory) throws Exception {
                WebDirectoryElementImpl.this.addChild(name, isDirectory, this.val$children);
                return true;
            }
        });
        WebDirectoryElement[] webDirectoryElementArray = children.toArray(new WebDirectoryElement[children.size()]);
        if (webDirectoryElementArray == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(10);
        }
        return webDirectoryElementArray;
    }

    public boolean processChildren(final PsiElementProcessor<PsiFileSystemItem> processor) {
        final WebDirectoryElementImpl element = new WebDirectoryElementImpl(this.myWebFacet, "", false);
        return this.processChildren(new WebDirectoryElement.WebDirectoryProcessor(){

            public boolean execute(String name, boolean isDirectory) throws Exception {
                if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(name, isDirectory)) {
                    return true;
                }
                element.myIsDirectory = isDirectory;
                element.myPath = DeploymentUtil.appendToPath((String)"/", (String)PathUtil.getCanonicalPath((String)DeploymentUtil.appendToPath((String)WebDirectoryElementImpl.this.getPath(), (String)name)));
                return processor.execute((PsiElement)element);
            }
        });
    }

    public boolean processChildren(@NotNull WebDirectoryElement.WebDirectoryProcessor processor) {
        if (processor == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(11);
        }
        try {
            return this.myWebFacetContextService.processChildren(this.myWebFacet, this.myPath, processor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private void addChild(String name, boolean isDirectory, Collection<WebDirectoryElement> children) {
        WebDirectoryElement child = this.createElement(name, isDirectory);
        if (child != null) {
            children.add(child);
        }
    }

    public WebDirectoryElement createElement(String name, boolean isDirectory) {
        if (!FileTypeManager.getInstance().isFileIgnored(name)) {
            WebDirectoryElementImpl element = new WebDirectoryElementImpl(this.myWebFacet, DeploymentUtil.appendToPath((String)this.getPath(), (String)name), isDirectory);
            if (!isDirectory || element.isValid()) {
                return element;
            }
        }
        return null;
    }

    public PsiElement resolveRelative(String path) {
        WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil(this.myManager.getProject());
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            return webDirectoryUtil.findFileByPath(path, this.myWebFacet);
        }
        String localName = PathUtil.getCanonicalPath((String)DeploymentUtil.appendToPath((String)this.getPath(), (String)path));
        if (localName == null) {
            return null;
        }
        return webDirectoryUtil.findFileByPath("/" + localName, this.myWebFacet);
    }

    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    @Nullable
    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(12);
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(13);
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(14);
        }
        return false;
    }

    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(15);
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(16);
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(17);
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(18);
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            try {
                file.delete((Object)this.myManager);
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
    }

    public void checkDelete() throws IncorrectOperationException {
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            CheckUtil.checkDelete((VirtualFile)file);
        }
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(19);
        }
        throw new IncorrectOperationException();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        WebDirectoryElement[] packs;
        if (processor == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(20);
        }
        if (state == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(21);
        }
        if (place == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(22);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (WebDirectoryElement element : packs = this.getChildren()) {
            WebDirectoryElement toProcess;
            Object object = toProcess = element.isDirectory() ? element : element.getOriginalFile();
            if (toProcess == null || processor.execute((PsiElement)toProcess, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiFile file = this.getOriginalFile();
        WebDirectoryElementImpl webDirectoryElementImpl = file == null ? this : file;
        if (webDirectoryElementImpl == null) {
            WebDirectoryElementImpl.$$$reportNull$$$0(23);
        }
        return webDirectoryElementImpl;
    }

    public boolean canNavigate() {
        return this.isDirectory() || super.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        PsiDirectory directory;
        if (!this.isDirectory()) {
            super.navigate(requestFocus);
            return;
        }
        VirtualFile virtualFile = this.getOriginalVirtualFile();
        PsiFile psiElement = null;
        if (virtualFile != null && virtualFile.isDirectory() && (directory = PsiManager.getInstance((Project)this.getProject()).findDirectory(virtualFile)) != null) {
            psiElement = directory;
        }
        PsiFile file = this.getOriginalFile();
        if (psiElement == null && file != null) {
            psiElement = file;
        }
        if (psiElement == null) {
            return;
        }
        Object[] path = WebRootFileUrl.getPath((PsiElement)psiElement);
        WebView.select(this.getProject(), path, requestFocus);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return WebDirectoryElementImpl.this.getPath();
            }

            public String getLocationString() {
                return "(" + WebDirectoryElementImpl.this.myWebFacet.getName() + ")";
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public boolean isPhysical() {
        return true;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof WebDirectoryElementImpl && ((WebDirectoryElementImpl)((Object)object)).getPath().equals(this.getPath()) && ((WebDirectoryElementImpl)((Object)object)).myManager.equals(this.myManager) && ((WebDirectoryElementImpl)((Object)object)).myWebFacet.equals((Object)this.myWebFacet);
    }

    public String toString() {
        return "Web directory '" + this.getPath() + "' in Web facet '" + JavaeeUtil.getFacetWithModuleName((JavaeeFacet)this.myWebFacet) + "'";
    }

    public ASTNode getNode() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalVirtualFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

