/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.artifact.WebFacetContextEvaluationService;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDirectoryUtil {
    private final Map<Pair<String, WebFacet>, WebDirectoryElement> myCachedWebDirectoryElements = ContainerUtil.createConcurrentSoftValueMap();
    private long myPsiModificationCount = -1L;
    private final PsiManager myPsiManager;
    private final WebFacetContextEvaluationService myFacetContextService;

    public WebDirectoryUtil(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        this.myFacetContextService = WebFacetContextEvaluationService.getInstance(this.myPsiManager.getProject());
    }

    public void clearWebDirectoryCaches() {
        this.myCachedWebDirectoryElements.clear();
    }

    @Nullable
    public static WebDirectoryElement resolveAbsolutePath(@NonNls String shortenPath, WebFacet webFacet) {
        WebUtil webUtil = WebUtil.getWebUtil();
        WebDirectoryElement candidate = webUtil.createWebDirectoryElement(webFacet, shortenPath, false);
        List originalVirtualFiles = candidate.getOriginalVirtualFiles();
        for (VirtualFile virtualFile : originalVirtualFiles) {
            if (virtualFile.isDirectory()) continue;
            return candidate;
        }
        candidate = webUtil.createWebDirectoryElement(webFacet, shortenPath, true);
        if (!originalVirtualFiles.isEmpty()) {
            return candidate;
        }
        final Ref ref = new Ref();
        WebDirectoryElement.WebDirectoryProcessor processor = new WebDirectoryElement.WebDirectoryProcessor(){

            public boolean execute(String name, boolean isDirectory) throws Exception {
                ref.set((Object)Boolean.TRUE);
                return false;
            }
        };
        candidate.processChildren(processor);
        return ref.isNull() ? null : candidate;
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryElementByPath(@NonNls String path, @NotNull WebFacet webFacet) {
        Pair key;
        WebDirectoryElement webDirectoryElement;
        String shortenPath;
        if (webFacet == null) {
            WebDirectoryUtil.$$$reportNull$$$0(0);
        }
        if ((shortenPath = PathUtil.getCanonicalPath((String)path)) == null) {
            return null;
        }
        long modCount = this.myPsiManager.getModificationTracker().getModificationCount();
        if (this.myPsiModificationCount != modCount) {
            this.clearWebDirectoryCaches();
            this.myPsiModificationCount = modCount;
        }
        if ((webDirectoryElement = this.myCachedWebDirectoryElements.get(key = Pair.create((Object)shortenPath, (Object)webFacet))) == null) {
            webDirectoryElement = WebDirectoryUtil.resolveAbsolutePath(shortenPath, webFacet);
            if (webDirectoryElement == null) {
                return null;
            }
            this.myCachedWebDirectoryElements.put((Pair<String, WebFacet>)key, webDirectoryElement);
        }
        return webDirectoryElement;
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryByFile(@NotNull VirtualFile file, @NotNull WebFacet webFacet) {
        String path;
        if (file == null) {
            WebDirectoryUtil.$$$reportNull$$$0(1);
        }
        if (webFacet == null) {
            WebDirectoryUtil.$$$reportNull$$$0(2);
        }
        if ((path = this.myFacetContextService.getRelativeOutputPathForFile(webFacet, file)) == null) {
            return null;
        }
        return this.findWebDirectoryElementByPath(WebDirectoryUtil.ensureStartingSlash(path), webFacet);
    }

    private static String ensureStartingSlash(String relativePath) {
        return !StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') ? "/" + relativePath : relativePath;
    }

    @Nullable
    public PsiFileSystemItem findFileByPath(String localName, @NotNull WebFacet webFacet) {
        WebDirectoryElement element;
        if (webFacet == null) {
            WebDirectoryUtil.$$$reportNull$$$0(3);
        }
        if ((element = this.findWebDirectoryElementByPath(localName, webFacet)) == null || element.isDirectory()) {
            return element;
        }
        return element.getOriginalFile();
    }

    @Nullable
    public VirtualFile findVirtualFileByPath(@NonNls String localName, @NotNull WebFacet webFacet) {
        WebDirectoryElement element;
        if (webFacet == null) {
            WebDirectoryUtil.$$$reportNull$$$0(4);
        }
        if ((element = this.findWebDirectoryElementByPath(localName, webFacet)) == null) {
            return null;
        }
        return element.getOriginalVirtualFile();
    }

    public static WebDirectoryUtil getWebDirectoryUtil(Project project) {
        return (WebDirectoryUtil)ServiceManager.getService((Project)project, WebDirectoryUtil.class);
    }

    @Nullable
    public static WebDirectoryElement findParentWebDirectory(@NotNull Project project, @NotNull VirtualFile file) {
        WebFacet webFacet;
        if (project == null) {
            WebDirectoryUtil.$$$reportNull$$$0(5);
        }
        if (file == null) {
            WebDirectoryUtil.$$$reportNull$$$0(6);
        }
        return (webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project)) != null ? WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryByFile(file.getParent(), webFacet) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/jsp/WebDirectoryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findWebDirectoryElementByPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findWebDirectoryByFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findVirtualFileByPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentWebDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

