/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.parser;

import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFileType;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlGeneratedParser;
import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.jpa.ql.psi.impl.QlFileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class QlParserDefinition
implements ParserDefinition {
    public static final IFileElementType EJBQL_FILE_ELEMENT_TYPE = new IFileElementType("EJBQL_FILE", (Language)JpqlLanguage.EJBQL);
    public static final IFileElementType HQL_FILE_ELEMENT_TYPE = new IFileElementType("HQL_FILE", (Language)JpqlLanguage.HQL);
    public static final IFileElementType JPQL_FILE_ELEMENT_TYPE = new IFileElementType("JPQL_FILE", (Language)JpqlLanguage.JPQL);
    public static final IFileElementType EQL_FILE_ELEMENT_TYPE = new IFileElementType("EQL_FILE", (Language)JpqlLanguage.EQL);
    public static final TokenSet WS = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    public static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{QlTypes.QL_STRING, QlTypes.QL_NUMBER, QlTypes.QL_TRUE, QlTypes.QL_FALSE});

    @NotNull
    public Lexer createLexer(Project project) {
        QlLexer qlLexer = new QlLexer(this.getFileNodeType().getLanguage());
        if (qlLexer == null) {
            QlParserDefinition.$$$reportNull$$$0(0);
        }
        return qlLexer;
    }

    public PsiParser createParser(Project project) {
        boolean production = !ApplicationManager.getApplication().isUnitTestMode();
        return production ? new QlGeneratedParser() : new QlGeneratedParser(){

            @Override
            protected boolean parse_root_(IElementType root_, PsiBuilder builder_, int level_) {
                return 1.statement_list(builder_, level_);
            }
        };
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WS;
        if (tokenSet == null) {
            QlParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            QlParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = LITERALS;
        if (tokenSet == null) {
            QlParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = QlTypes.Factory.createElement(node);
        if (psiElement == null) {
            QlParserDefinition.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode astNode, ASTNode astNode1) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public IFileElementType getFileNodeType() {
        return JPQL_FILE_ELEMENT_TYPE;
    }

    public PsiFile createFile(FileViewProvider fileViewProvider) {
        return new QlFileImpl(fileViewProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/ql/parser/QlParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Eql
    extends QlParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return EQL_FILE_ELEMENT_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new QlFileImpl(fileViewProvider, JpqlLanguage.EQL){

                @Override
                @NotNull
                public FileType getFileType() {
                    QlFileType qlFileType = QlFileType.EQL_FILE_TYPE;
                    if (qlFileType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return qlFileType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/parser/QlParserDefinition$Eql$1", "getFileType"));
                }
            };
        }
    }

    public static class Hql
    extends QlParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return HQL_FILE_ELEMENT_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new QlFileImpl(fileViewProvider, JpqlLanguage.HQL){

                @Override
                @NotNull
                public FileType getFileType() {
                    QlFileType qlFileType = QlFileType.HQL_FILE_TYPE;
                    if (qlFileType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return qlFileType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/parser/QlParserDefinition$Hql$1", "getFileType"));
                }
            };
        }
    }

    public static class Ejbql
    extends QlParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return EJBQL_FILE_ELEMENT_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new QlFileImpl(fileViewProvider, JpqlLanguage.EJBQL){

                @Override
                @NotNull
                public FileType getFileType() {
                    QlFileType qlFileType = QlFileType.EJBQL_FILE_TYPE;
                    if (qlFileType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return qlFileType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/parser/QlParserDefinition$Ejbql$1", "getFileType"));
                }
            };
        }
    }
}

