/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaQueryParameterReferenceProvider;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import java.text.MessageFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JpaQueryApiInspection
extends AbstractJpaInspection {
    @NonNls
    public static final String SHORT_NAME = "JpaQueryApiInspection";

    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.javaee.persistence.query.display.name", (Object[])new Object[0]);
        if (string == null) {
            JpaQueryApiInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            JpaQueryApiInspection.$$$reportNull$$$0(1);
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JpaQueryApiInspection.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                JpaQueryApiInspection.checkQueryApiReferences(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            JpaQueryApiInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private static void checkQueryApiReferences(PsiLiteralExpression literalExpression, ProblemsHolder holder, boolean isOnTheFly) {
        if (JpaQueryReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression) || JpaQueryParameterReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression)) {
            boolean badResolve;
            JpaQueryReferenceProvider.QueryRelatedReference relatedReference = JpaUtil.findReferenceOfType(literalExpression.getReferences(), JpaQueryReferenceProvider.QueryRelatedReference.class);
            boolean bl = badResolve = relatedReference != null && relatedReference.resolve() == null;
            if (badResolve) {
                String message = MessageFormat.format(relatedReference.getUnresolvedMessagePattern(), relatedReference.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(relatedReference.getElement(), relatedReference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, relatedReference.getQuickFixes()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaQueryApiInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaQueryApiInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

