/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DataBus;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.AbstractQlModel;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaConsoleBase
extends AbstractQueryLanguageConsole<PersistencePackagePointer> {
    private final PersistencePackagePointer myUnitFile;
    private final ConsoleRunConfiguration myConfiguration;
    private SyntaxHighlighter myHighlighter;
    private final QlScriptModel myScriptModel;

    protected JpaConsoleBase(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @NotNull String historyId, @NotNull Language language, @Nullable String query) {
        if (unitFile == null) {
            JpaConsoleBase.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            JpaConsoleBase.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            JpaConsoleBase.$$$reportNull$$$0(2);
        }
        if (historyId == null) {
            JpaConsoleBase.$$$reportNull$$$0(3);
        }
        if (language == null) {
            JpaConsoleBase.$$$reportNull$$$0(4);
        }
        super(unitFile.getFacetPointer().getProject(), messageBus, (Object)unitFile, unitFile.getElementName(), language);
        this.myUnitFile = unitFile;
        this.myConfiguration = configuration;
        ConsoleHistoryController controller = new ConsoleHistoryController(historyId, ((VirtualFile)unitFile).getPresentableUrl(), this.getLanguageConsole());
        this.getLanguageConsole().setInputText(StringUtil.notNullize((String)query));
        this.myScriptModel = new QlScriptModel((QlFile)this.getLanguageConsole().getFile());
        Disposer.register((Disposable)this, (Disposable)this.myScriptModel);
        controller.install();
    }

    @NotNull
    public QlScriptModel getScriptModel() {
        QlScriptModel qlScriptModel = this.myScriptModel;
        if (qlScriptModel == null) {
            JpaConsoleBase.$$$reportNull$$$0(5);
        }
        return qlScriptModel;
    }

    protected abstract String getHelpID();

    public abstract boolean isStarted();

    public abstract void terminate();

    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        ConsoleRunConfiguration consoleRunConfiguration = this.myConfiguration;
        if (consoleRunConfiguration == null) {
            JpaConsoleBase.$$$reportNull$$$0(6);
        }
        return consoleRunConfiguration;
    }

    protected DataAuditor.ConsoleLogger createHistoryLogger() {
        return new DataAuditor.ConsoleLogger((ConsoleView)this.getLanguageConsole()){

            public void print(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context.request instanceof GenerateSql) {
                    JpaConsoleBase.this.printSql(message);
                } else {
                    super.print(context, message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/engine/JpaConsoleBase$1", "print"));
            }
        };
    }

    protected void buildConsoleUi(boolean focused) {
        boolean isHibernate = this.getLanguageConsole().getFile().getLanguage() == JpqlLanguage.HQL;
        this.getLanguageConsole().getFile().putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)new MyAbstractQlModel(this.getProject(), this.myUnitFile, isHibernate));
        AnAction toggleAction = this.initParameterView();
        this.myDataConsumer.resetOutputTabCounter();
        this.getUi().getDefaults().initTabDefaults(0, null, null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getLanguageConsole().getComponent(), (Object)"Center");
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, this.getTitle(), AllIcons.Debugger.Console, this.getLanguageConsole().getPreferredFocusableComponent());
        DefaultActionGroup outputActions = new DefaultActionGroup();
        JpaConsoleBase.addLeftToolbarConsoleActions((DefaultActionGroup)outputActions, (ConsoleView)this.getLanguageConsole());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getLanguageConsole().getComponent());
        this.getUi().getOptions().setLeftToolbar((ActionGroup)this.createActionGroup(toggleAction), "toolbar");
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
    }

    private String collectQueryTextAndParams(ScriptModel.StatementIt<?> it, Map<Object, String> params) {
        boolean isHibernate = !(this instanceof JpaConsole);
        String text = it.text(this.myPStorage, o -> {
            String s = o.name();
            String value = String.valueOf(this.myPStorage.getValue((Object)s));
            if (s.startsWith("?")) {
                String key;
                String name = s.substring(1);
                try {
                    key = name.isEmpty() ? Integer.valueOf(params.size() + (isHibernate ? 0 : 1)) : (isHibernate ? name : Integer.valueOf(Integer.parseInt(name)));
                }
                catch (NumberFormatException e) {
                    key = name;
                }
                params.put(key, value);
                return true;
            }
            if (s.startsWith(":")) {
                String name = s.substring(1);
                if (StringUtil.isJavaIdentifier((String)name)) {
                    params.put(name, value);
                    return true;
                }
            } else {
                int num = StringUtil.parseInt((String)s, (int)0);
                if (num > 0) {
                    params.put(isHibernate ? num - 1 : num, value);
                    return true;
                }
            }
            return false;
        });
        return text;
    }

    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
        if (parent == null) {
            JpaConsoleBase.$$$reportNull$$$0(7);
        }
        return GridDataHookUpManager.getInstance((Project)this.getProject()).createJpaHookUp(this.getMessageBus(), parent);
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model) {
        if (sourceEditor == null) {
            JpaConsoleBase.$$$reportNull$$$0(8);
        }
        if (model == null) {
            JpaConsoleBase.$$$reportNull$$$0(9);
        }
        for (ScriptModel.StatementIt it : model.statements()) {
            this.executeQueryInner(it);
        }
    }

    private void executeQueryInner(ScriptModel.StatementIt<?> it) {
        HashMap params = ContainerUtil.newHashMap();
        String query = this.collectQueryTextAndParams(it, params);
        if (StringUtil.isEmpty((String)query)) {
            return;
        }
        ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getLanguageConsole(), (String)query);
        List columnNames = (List)it.resultType(null);
        LoadRequest request = new LoadRequest((DataRequest.Owner)this, query, params, columnNames);
        this.getMessageBus().getDataProducer().processRequest((DataRequest)request);
    }

    public void generateSQL() {
        this.myParamPanel.commit();
        ScriptModel.StatementIt it = (ScriptModel.StatementIt)this.myScriptModel.statements().first();
        if (it == null) {
            return;
        }
        String query = this.collectQueryTextAndParams(it, new HashMap<Object, String>());
        this.getLanguageConsole().print("> " + query + "\n", ConsoleViewContentType.USER_INPUT);
        if (query.isEmpty()) {
            return;
        }
        this.getMessageBus().getDataProducer().processRequest((DataRequest)new GenerateSql((DataRequest.OwnerEx)this, query, Command.QUERY));
    }

    public void generateDDL() {
        this.getMessageBus().getDataProducer().processRequest((DataRequest)new GenerateSql((DataRequest.OwnerEx)this, "", Command.DDL));
    }

    private DefaultActionGroup createActionGroup(AnAction toggleAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        RunAction runAction = new RunAction();
        DumbAwareAction sqlAction = new DumbAwareAction(null, null, DatabaseIcons.ExportSQL){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.generateSQL();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(JpaConsoleBase.this.getLanguageConsole().getEditorDocument().getText().trim().length() > 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction ddlAction = new DumbAwareAction(null, null, DatabaseIcons.ExportDDL){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.generateDDL();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction closeAction = new DumbAwareAction(null, null, AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.getContent().getManager().removeContent(JpaConsoleBase.this.getContent(), true);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction terminateAction = new DumbAwareAction(null, null, AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                JpaConsoleBase.this.terminate();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(JpaConsoleBase.this.isStarted());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        group.add((AnAction)runAction);
        group.add((AnAction)sqlAction);
        group.add((AnAction)ddlAction);
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("Database.Settings"));
        group.add(toggleAction);
        group.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        group.add(this.getUi().getOptions().getLayoutActions());
        group.addSeparator();
        group.add((AnAction)terminateAction);
        group.add((AnAction)closeAction);
        EmptyAction.setupAction((AnAction)runAction, (String)"Console.Jpa.Execute", null);
        EmptyAction.setupAction((AnAction)closeAction, (String)"Console.Jpa.Close", null);
        EmptyAction.setupAction((AnAction)terminateAction, (String)"Console.Jpa.Terminate", null);
        EmptyAction.setupAction((AnAction)sqlAction, (String)"Console.Jpa.GenerateSql", null);
        EmptyAction.setupAction((AnAction)ddlAction, (String)"Console.Jpa.GenerateDDL", null);
        for (AnAction action : group.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        return group;
    }

    public void printSql(@Nullable String sql) {
        if (this.myHighlighter == null) {
            this.getHistoryLogger().print(sql);
        } else if (!StringUtil.isEmptyOrSpaces((String)sql)) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)this.getLanguageConsole(), (String)sql.trim(), (SyntaxHighlighter)this.myHighlighter);
            this.getHistoryLogger().newLine();
        }
        this.getHistoryLogger().newLine();
    }

    public void initHighlighter(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JpaConsoleBase.$$$reportNull$$$0(10);
        }
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((LocalDataSource)dataSource);
        this.myHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initHighlighter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LoadRequest
    extends DataRequest.QueryRequest {
        public final List<String> expectedColumns;

        public LoadRequest(DataRequest.Owner owner, String query, Map<Object, String> params, List<String> names) {
            super(owner, NONE, query, LoadRequest.newConstraints((int)0, (int)DatabaseSettings.getSettings().getPageSize(), (int)-1), params);
            this.expectedColumns = names;
        }
    }

    public static class GenerateSql
    extends DataRequest {
        public final Command command;
        public final String query;

        GenerateSql(DataRequest.OwnerEx owner, String query, Command command) {
            super((DataRequest.Owner)owner, owner.getCurrentTx());
            this.command = command;
            this.query = query;
        }
    }

    public static enum Command {
        QUERY,
        DDL;

    }

    private class RunAction
    extends DumbAwareAction
    implements Toggleable {
        public RunAction() {
            super(null, null, AllIcons.Actions.Execute);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean ranged;
            if (e == null) {
                RunAction.$$$reportNull$$$0(0);
            }
            QlScriptModel scriptModel = JpaConsoleBase.this.getScriptModel();
            TextRange selectionRange = EditorUtil.getSelectionInAnyMode((Editor)JpaConsoleBase.this.getLanguageConsole().getCurrentEditor());
            boolean bl = ranged = selectionRange.getLength() > 0;
            if (ranged) {
                scriptModel = scriptModel.subModel((TextRange)new ScriptModel.StrictRange(selectionRange));
            }
            if (JpaConsoleBase.this.beforeExecuteQueries(scriptModel)) {
                JpaConsoleBase.this.executeQueries((Editor)JpaConsoleBase.this.getLanguageConsole().getCurrentEditor(), scriptModel);
                if (!ranged) {
                    JpaConsoleBase.this.getLanguageConsole().setInputText("");
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RunAction.$$$reportNull$$$0(1);
            }
            boolean enabled = !StringUtil.isEmptyOrSpaces((String)JpaConsoleBase.this.getLanguageConsole().getEditorDocument().getText());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().putClientProperty("selected", (Object)(!JpaConsoleBase.this.isIdle() ? 1 : 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$RunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyAbstractQlModel
    extends AbstractQlModel {
        private final PersistenceFacet myFacet;
        private final PersistencePackagePointer myUnitFile;
        private final boolean myHibernate;

        public MyAbstractQlModel(Project project, PersistencePackagePointer unitFile, boolean isHibernate) {
            super(project);
            this.myHibernate = isHibernate;
            this.myFacet = unitFile.getPersistenceFacet();
            this.myUnitFile = unitFile;
        }

        @Override
        protected void processPersistenceMappings(PairProcessor<PersistenceMappings, PersistenceModelBrowser> processor) {
            PersistencePackage unit;
            if (FacetUtil.isRegistered((Facet)((Facet)this.myFacet)) && (unit = this.myUnitFile.findElement()) != null && unit.isValid()) {
                PersistenceMappings entityMappings = this.myFacet.getEntityMappings(unit);
                PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this.myFacet, (PersistencePackage)unit, null);
                processor.process((Object)entityMappings, (Object)browser);
            }
        }

        @Override
        protected boolean isHibernate() {
            return this.myHibernate;
        }

        @Override
        @NotNull
        protected List<? extends PersistenceFacet> getPersistenceFacets() {
            List<PersistenceFacet> list = Collections.singletonList(this.myFacet);
            if (list == null) {
                MyAbstractQlModel.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConsoleBase$MyAbstractQlModel", "getPersistenceFacets"));
        }
    }

    public static abstract class Builder<T> {
        protected final PersistencePackagePointer myUnitFile;
        protected ConsoleRunConfiguration myConfiguration;
        protected String myQuery;

        protected Builder(@NotNull PersistencePackagePointer unitFile) {
            if (unitFile == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myUnitFile = unitFile;
        }

        public Builder<T> withQuery(@Nullable CharSequence query) {
            this.myQuery = query == null ? null : query.toString();
            return this;
        }

        public Builder<T> withRunConfiguration(@Nullable ConsoleRunConfiguration configuration) {
            this.myConfiguration = configuration;
            return this;
        }

        @NotNull
        protected Project getProject() {
            Project project = this.myUnitFile.getFacetPointer().getProject();
            if (project == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return project;
        }

        public abstract T build();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unitFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaConsoleBase$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleBase$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

