/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddJpaProviderSupport
extends DefaultActionGroup
implements DumbAware {
    public AddJpaProviderSupport() {
        for (final JpaImplementationProvider provider : (JpaImplementationProvider[])Extensions.getExtensions((ExtensionPointName)JpaImplementationProvider.EP_NAME)) {
            this.add(new AnAction(provider.getProviderName(), provider.getProviderName(), provider.getProviderIcon()){

                public void update(AnActionEvent e) {
                    PersistenceUnit unit = AddJpaProviderSupport.getPersistenceUnit(e);
                    e.getPresentation().setEnabledAndVisible(unit != null);
                }

                public void actionPerformed(AnActionEvent e) {
                    final Project project = e.getProject();
                    final PersistenceUnit unit = AddJpaProviderSupport.getPersistenceUnit(e);
                    if (project == null || unit == null) {
                        return;
                    }
                    final RawConnectionConfig info = AddJpaProviderSupport.findConnectionInfo(project, unit);
                    final Credentials credentials = info == null ? null : DatabaseCredentials.getInstance().getCredentials((DatabaseSystem)info);
                    new WriteCommandAction(unit.getManager().getProject(), new PsiFile[]{unit.getContainingFile()}){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (info != null) {
                                provider.setConnectionProperties(project, unit, info, credentials);
                            } else {
                                provider.setDefaultProperties(unit);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/actions/AddJpaProviderSupport$1$1", "run"));
                        }
                    }.execute();
                }
            });
        }
        this.setPopup(true);
    }

    public void update(AnActionEvent e) {
        PersistenceUnit unit = AddJpaProviderSupport.getPersistenceUnit(e);
        e.getPresentation().setEnabledAndVisible(unit != null);
    }

    @Nullable
    private static RawConnectionConfig findConnectionInfo(@NotNull Project project, @NotNull PersistenceUnit unit) {
        if (project == null) {
            AddJpaProviderSupport.$$$reportNull$$$0(0);
        }
        if (unit == null) {
            AddJpaProviderSupport.$$$reportNull$$$0(1);
        }
        List facets = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets((PersistencePackage)unit);
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        for (PersistenceFacet facet : facets) {
            DbDataSource dataSource;
            RawConnectionConfig info;
            String id = facet.getDataSourceId((PersistencePackage)unit);
            if (id == null || (info = (dataSource = dbPsiFacade.findDataSource(id)) == null ? null : dataSource.getConnectionConfig()) == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    private static PersistenceUnit getPersistenceUnit(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file == null || editor == null) {
            return null;
        }
        DomElement element = DomUtil.getDomElement((Editor)editor, (PsiFile)file);
        return element == null ? null : (PersistenceUnit)element.getParentOfType(PersistenceUnit.class, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "unit";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/actions/AddJpaProviderSupport";
        objectArray[2] = "findConnectionInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

