/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.facet.JavaeeFrameworkSupportProvider;
import com.intellij.javaee.model.enums.WebAppVersion;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WebFacetFrameworkSupportProvider
extends JavaeeFrameworkSupportProvider<WebFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.facet.WebFacetFrameworkSupportProvider");
    private boolean myCreateWebXml;

    public WebFacetFrameworkSupportProvider() {
        super(WebFacetType.getInstance(), DeploymentDescriptorsConstants.WEB_XML_META_DATA, "/web");
    }

    public String getGroupId() {
        return "web";
    }

    @Override
    protected void setupConfiguration(WebFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        super.setupConfiguration(facet, rootModel, version);
        String webDirUrl = rootModel.getContentRootUrls()[0] + "/web";
        facet.addWebRoot(webDirUrl, "/");
        WebFacetImpl webFacet = (WebFacetImpl)facet;
        webFacet.getWebConfiguration().setSourceRoots(Arrays.asList(rootModel.getSourceRootUrls(false)));
    }

    @Override
    protected JavaeeArtifactTypeBase getExplodedArtifactType() {
        return ExplodedWarArtifactType.getInstance();
    }

    @Override
    protected void createFiles(WebFacet facet, JavaeeFrameworkSupportInfoCollector collector) {
        List webRoots = facet.getWebRoots();
        if (webRoots.isEmpty()) {
            return;
        }
        String webRootUrl = ((WebRoot)webRoots.get(0)).getDirectoryUrl();
        try {
            File ioFile = new File(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)webRootUrl)), "index.jsp");
            if (ioFile.exists()) {
                return;
            }
            FileUtil.createIfDoesntExist((File)ioFile);
            VirtualFile indexFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            Project project = facet.getModule().getProject();
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("Jsp File.jsp");
            assert (indexFile != null);
            VfsUtil.saveText((VirtualFile)indexFile, (String)fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties()));
            collector.setIndexJsp(indexFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public void processAddedLibraries(Module module, List<Library> addedLibraries) {
        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module), null);
        if (webFacet != null) {
            Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (ArtifactType)ExplodedWarArtifactType.getInstance());
            for (Artifact artifact : artifacts) {
                for (Library library : addedLibraries) {
                    if (JavaeeArtifactTypeBase.isStandardJavaeeLibary(library)) continue;
                    WebArtifactUtil.getInstance().addLibrary(library, artifact, module.getProject());
                }
            }
        }
    }

    public String getTitle() {
        return WebBundle.message("framework.title.web.application", new Object[0]);
    }

    @Override
    protected ConfigFileVersion getVersionToCreate(String versionString) {
        return WebAppVersion.WebAppVersion_3_0.getValue().equals(versionString) && !this.myCreateWebXml ? null : super.getVersionToCreate(versionString);
    }

    @Override
    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            WebFacetFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        WebFrameworkSupportConfigurable webFrameworkSupportConfigurable = new WebFrameworkSupportConfigurable(model);
        if (webFrameworkSupportConfigurable == null) {
            WebFacetFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return webFrameworkSupportConfigurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/facet/WebFacetFrameworkSupportProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/facet/WebFacetFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class WebFrameworkSupportConfigurable
    extends JavaeeFrameworkSupportProvider.JavaeeFrameworkSupportConfigurable {
        private JPanel myPanel;
        private JCheckBox myCreateWebXmlBox;

        public WebFrameworkSupportConfigurable(FrameworkSupportModel model) {
            super(WebFacetFrameworkSupportProvider.this, (FrameworkSupportProviderBase)WebFacetFrameworkSupportProvider.this, model, WebFacetFrameworkSupportProvider.this.getVersions(), WebFacetFrameworkSupportProvider.this.getVersionLabelText());
            this.myPanel = new JPanel(new BorderLayout(5, 5));
            this.myCreateWebXmlBox = new JCheckBox("Create web.xml");
            this.myCreateWebXmlBox.setSelected(true);
            this.myPanel.add((Component)super.getComponent(), "West");
            this.myPanel.add((Component)this.myCreateWebXmlBox, "Center");
            this.myCreateWebXmlBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFacetFrameworkSupportProvider.this.myCreateWebXml = WebFrameworkSupportConfigurable.this.myCreateWebXmlBox.isSelected();
                }
            });
        }

        private void updateCheckBox() {
            FrameworkVersion version = this.getSelectedVersion();
            boolean is3_0 = version != null && WebAppVersion.WebAppVersion_3_0.getValue().equals(version.getVersionName());
            this.myCreateWebXmlBox.setSelected(!is3_0 || WebFacetFrameworkSupportProvider.this.myCreateWebXml);
            this.myCreateWebXmlBox.setVisible(is3_0);
        }

        public JComponent getComponent() {
            this.updateCheckBox();
            return this.myPanel;
        }

        protected void fireFrameworkVersionChanged() {
            super.fireFrameworkVersionChanged();
            this.updateCheckBox();
        }
    }
}

