/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.model.jam.JamFilter;
import com.intellij.javaee.model.jam.JamListener;
import com.intellij.javaee.model.jam.JamServlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebModelContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebModelBase
implements WebModel {
    public List<CommonServlet> getServlets() {
        return this.getMergedElements(JamServlet.SERVLET_CLASS_META, "javax.servlet.annotation.WebServlet", webApp -> new ArrayList(webApp.getServlets()), (contributor, module) -> contributor.getServlets(module));
    }

    public CommonServlet findServlet(@NotNull String name) {
        if (name == null) {
            WebModelBase.$$$reportNull$$$0(0);
        }
        return (CommonServlet)ContainerUtil.find(this.getServlets(), o -> {
            if (name == null) {
                WebModelBase.$$$reportNull$$$0(3);
            }
            return name.equals(o.getServletName().getStringValue());
        });
    }

    public CommonFilter findFilter(@NotNull String name) {
        if (name == null) {
            WebModelBase.$$$reportNull$$$0(1);
        }
        return (CommonFilter)ContainerUtil.find(this.getFilters(), o -> {
            if (name == null) {
                WebModelBase.$$$reportNull$$$0(2);
            }
            return name.equals(o.getFilterName().getStringValue());
        });
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings() {
        return this.getMergedElements(JamServlet.SERVLET_CLASS_META, "javax.servlet.annotation.WebServlet", webApp -> new ArrayList(webApp.getServletMappings()), (contributor, module) -> contributor.getServletMappings(module));
    }

    private <T> List<T> getMergedElements(JamClassMeta<? extends T> servletClassMeta, String annoName, Function<WebApp, List<T>> webAppFunction, PairFunction<WebModelContributor, Module, List<T>> contributorFunction) {
        if (DumbService.isDumb((Project)this.getModule().getProject())) {
            return Collections.emptyList();
        }
        Collection<WebApp> models = this.getApps();
        ArrayList result = new ArrayList();
        for (WebApp model : models) {
            result.addAll((Collection)webAppFunction.fun((Object)model));
        }
        for (WebModelContributor webModelContributor : (WebModelContributor[])WebModelContributor.EP_NAME.getExtensions()) {
            result.addAll((Collection)contributorFunction.fun((Object)webModelContributor, (Object)this.getModule()));
        }
        JamService service = JamService.getJamService((Project)this.getModule().getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)this.getModule(), (boolean)false);
        result.addAll(service.getJamClassElements(servletClassMeta, annoName, scope));
        return result;
    }

    @NotNull
    protected abstract Module getModule();

    protected abstract Collection<WebApp> getApps();

    public List<CommonFilter> getFilters() {
        return this.getMergedElements(JamFilter.FILTER_CLASS_META, "javax.servlet.annotation.WebFilter", webApp -> new ArrayList(webApp.getFilters()), (contributor, module) -> contributor.getFilters(module));
    }

    public List<CommonListener> getListeners() {
        return this.getMergedElements(JamListener.LISTENER_CLASS_META, "javax.servlet.annotation.WebListener", webApp -> new ArrayList(webApp.getListeners()), (contributor, module) -> contributor.getListeners(module));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "name";
        objectArray2[1] = "com/intellij/javaee/web/WebModelBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findServlet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findFilter$3";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findServlet$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

