/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.tree.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.toolwindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.javaee.toolwindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationTypeNode
extends PsiMemberSimpleNode {
    protected Module myModule;
    protected PsiClass myAnnoClass;

    public AnnotationTypeNode(@NotNull Module module, @NotNull PsiClass annoClass, SimpleNode parent) {
        if (module == null) {
            AnnotationTypeNode.$$$reportNull$$$0(0);
        }
        if (annoClass == null) {
            AnnotationTypeNode.$$$reportNull$$$0(1);
        }
        super(parent, annoClass);
        this.myModule = module;
        this.myAnnoClass = annoClass;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        if (!this.myAnnoClass.isValid()) {
            return;
        }
        presentation.addText(new PresentableNodeDescriptor.ColoredFragment(this.myAnnoClass.getName(), this.myAnnoClass.getQualifiedName(), this.getPlainAttributes()));
        presentation.setIcon(PlatformIcons.ANNOTATION_TYPE_ICON);
    }

    public SimpleNode[] getChildren() {
        Collection<PsiMemberSimpleNode> children = AnnotationTypeNode.createSortedList();
        if (this.myAnnoClass.isValid()) {
            for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)this.myAnnoClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule)).findAll()) {
                children.add(new AnnotatedMembersNode<PsiMember>(this.myModule, psiMember, this));
            }
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myAnnoClass, this.myModule};
        if (objectArray == null) {
            AnnotationTypeNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    protected List<PsiClass> findAnnotatedClasses() {
        return this.findAnnotatedMembers(PsiClass.class);
    }

    protected List<PsiMethod> findAnnotatedMethods() {
        return this.findAnnotatedMembers(PsiMethod.class);
    }

    protected <T extends PsiModifierListOwner> List<T> findAnnotatedMembers(Class<T> clazz) {
        ArrayList result = ContainerUtil.newArrayList();
        Processor processor = t -> {
            ContainerUtil.addIfNotNull((Collection)result, (Object)t);
            return true;
        };
        JamCommonUtil.findAnnotatedElements(clazz, (String)this.myAnnoClass.getQualifiedName(), (PsiManager)PsiManager.getInstance((Project)this.myModule.getProject()), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule), (Processor)processor);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/toolwindow/tree/nodes/AnnotationTypeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/toolwindow/tree/nodes/AnnotationTypeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

