/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.view.JavaeeConsoleViewImpl;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.run.execution.JavaeePlainConsoleView;
import com.intellij.javaee.run.execution.update.SelectUpdatingPolicyDialog;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerStateListener;
import com.intellij.javaee.serverInstances.RunAppServerInstanceManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.net.NetUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance(ExecutionHelper.class);
    private final CommonStrategy myConfiguration;

    public ExecutionHelper(CommonStrategy configuration) {
        this.myConfiguration = configuration;
    }

    public ConsoleView createConsole(J2EEProcess j2eeProcess, Executor executor) {
        GlobalSearchScope scope = SearchScopeProvider.createSearchScope((Project)this.getProject(), (RunProfile)this.myConfiguration);
        ConsoleView plainConsole = TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), scope).getConsole();
        if (this.myConfiguration.getDeploymentProvider() == null) {
            return new JavaeePlainConsoleView(plainConsole, this.getIntegration(), j2eeProcess);
        }
        return new JavaeeConsoleViewImpl(this.getProject(), this.myConfiguration, j2eeProcess, executor, plainConsole);
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        AppServerDeployedFileUrlProvider urlProvider;
        final J2EEServerInstance newInstance = this.myConfiguration.createServerInstance();
        if (this.myConfiguration.getDeploymentProvider() != null) {
            final DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)this.getProject());
            final boolean needUndeployOnDisconnect = this.myConfiguration.getDeploymentProvider().isNeedUndeployOnDisconnect();
            new ServerStateWaiter(newInstance){

                @Override
                protected boolean isInState(J2EEServerEvent event) {
                    return event.isStateRunning();
                }

                @Override
                protected void onInState(J2EEServerInstance instance) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (needUndeployOnDisconnect) {
                            deploymentManager.initKeepDeployedAfterDisconnect(instance, (CommonModel)ExecutionHelper.this.myConfiguration);
                        }
                        deploymentManager.deployAllModules(instance, (CommonModel)ExecutionHelper.this.myConfiguration, false, null);
                    }, ExecutionHelper.this.getProject().getDisposed());
                }
            };
            if (needUndeployOnDisconnect) {
                new ServerStateWaiter(newInstance){

                    @Override
                    protected boolean isInState(J2EEServerEvent event) {
                        return event.isStateBeforeDisconnect();
                    }

                    @Override
                    protected void onInState(J2EEServerInstance instance) {
                        deploymentManager.undeployNonKeptModules(instance, (CommonModel)ExecutionHelper.this.myConfiguration);
                    }
                };
                new ServerStateWaiter(newInstance){

                    @Override
                    protected boolean isInState(J2EEServerEvent event) {
                        return event.isStateProcessKilled();
                    }

                    @Override
                    protected void onInState(J2EEServerInstance instance) {
                        deploymentManager.clean(instance, (CommonModel)ExecutionHelper.this.myConfiguration);
                    }
                };
            }
        }
        if ((urlProvider = this.getIntegration().getDeployedFileUrlProvider()) instanceof ApplicationServerUrlMapping) {
            final ApplicationServerUrlMapping urlMapping = (ApplicationServerUrlMapping)urlProvider;
            urlMapping.startTrackingServerInstance(newInstance);
            final JavaeeDeploymentListener deploymentListener = new JavaeeDeploymentListener(){

                public void deploymentStatusChanged(DeploymentModel model, DeploymentStatus newStatus, CommonModel runConfiguration) {
                    urlMapping.updateDeploymentContexts(newInstance, model, newStatus == DeploymentStatus.DEPLOYED);
                }
            };
            final DeploymentManagerEx deploymentManagerEx = DeploymentManagerEx.getInstanceEx(this.getProject());
            deploymentManagerEx.addDeploymentListener(newInstance, deploymentListener);
            new ServerStateWaiter(newInstance){

                @Override
                protected boolean isInState(J2EEServerEvent event) {
                    return event.isStateDisconnected();
                }

                @Override
                protected void onInState(J2EEServerInstance instance) {
                    deploymentManagerEx.removeDeploymentListener(newInstance, deploymentListener);
                    urlMapping.stopTrackingServerInstance(newInstance);
                }
            };
        }
        return newInstance;
    }

    public DefaultExecutionResult createExecutionResult(J2EEProcess j2eeProcess, Executor executor) {
        ConsoleView consoleView;
        ProcessHandler resultHandler = (ProcessHandler)j2eeProcess;
        resultHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            consoleView = this.createConsole(j2eeProcess, executor);
            consoleView.attachToProcess(resultHandler);
        } else {
            consoleView = null;
        }
        return new DefaultExecutionResult((ExecutionConsole)consoleView, resultHandler, new AnAction[]{ActionManager.getInstance().getAction("JavaeeRunToolWindowToolbar")});
    }

    private Project getProject() {
        return this.myConfiguration.getProject();
    }

    private AppServerIntegration getIntegration() {
        return this.myConfiguration.getIntegration();
    }

    public void checkAddressesAlreadyInUse(J2EEProcessHandlerWrapper processHandlerWrapper) throws CantRunException {
        List<Pair<String, Integer>> addresses = this.myConfiguration.getAddressesToCheck();
        for (Pair<String, Integer> pair : addresses) {
            String host = (String)pair.getFirst();
            int port = (Integer)pair.getSecond();
            String addressText = host + ":" + port;
            if (NetUtils.canConnectToSocket((String)host, (int)port)) {
                throw new CantRunException(J2EEBundle.message((String)"exception.text.address.is.in.use", (Object[])new Object[]{addressText}));
            }
            if (!NetUtils.isLocalhost((String)host) || !NetUtils.canConnectToRemoteSocket((String)host, (int)port)) continue;
            processHandlerWrapper.showWarning(J2EEBundle.message((String)"message.text.able.to.bind.yet.able.to.connect.too", (Object[])new Object[]{addressText}));
        }
    }

    public boolean processRunInstance(@NotNull Executor executor) {
        RunAppServerInstanceManager runAppServerInstanceManager;
        J2EEServerInstance existingInstance;
        if (executor == null) {
            ExecutionHelper.$$$reportNull$$$0(0);
        }
        if ((existingInstance = (runAppServerInstanceManager = RunAppServerInstanceManager.getInstance((Project)this.myConfiguration.getProject())).findInstance((CommonModel)this.myConfiguration)) == null) {
            return false;
        }
        ProcessHandler handler = runAppServerInstanceManager.findHandler(existingInstance);
        if (existingInstance.isStopped() || handler == null || handler.isProcessTerminating() || handler.isProcessTerminated()) {
            return false;
        }
        String name = this.myConfiguration.getName();
        Executor oldExecutor = UpdatingRunningApplicationUtil.getExecutor(this.getProject(), handler);
        if (!executor.equals(oldExecutor)) {
            String message = J2EEBundle.message((String)"message.text.run.configuration.already.run.do.you.want.to.restart.in.1", (Object[])new Object[]{name, executor.getActionName()});
            int answer = Messages.showYesNoDialog((Project)this.getProject(), (String)message, (String)J2EEBundle.message((String)"dialog.title.restart.server", (Object[])new Object[0]), null);
            if (answer == 0) {
                UpdatingPolicy policy = UpdatingRunningApplicationUtil.findPolicy("restart-server");
                LOG.assertTrue(policy != null);
                policy.runUpdate(this.getProject(), executor, existingInstance, handler, false);
            }
            return true;
        }
        Collection<? extends UpdatingPolicy> policies = UpdatingRunningApplicationUtil.getAvailablePolicies(executor, this.myConfiguration, false);
        if (!policies.isEmpty()) {
            String description = J2EEBundle.message((String)"message.text.run.configuration.already.run", (Object[])new Object[]{name});
            SelectUpdatingPolicyDialog dialog = new SelectUpdatingPolicyDialog(this.getProject(), name, description, false, policies, this.myConfiguration.getUpdatingPolicy());
            dialog.show();
            if (dialog.getExitCode() == 0) {
                dialog.getSelectedPolicy().runUpdate(this.getProject(), executor, existingInstance, handler, false);
                ExecutionManager executionManager = ExecutionManager.getInstance((Project)this.getProject());
                executionManager.getContentManager().toFrontRunContent(executor, handler);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javaee/run/execution/ExecutionHelper", "processRunInstance"));
    }

    private static abstract class ServerStateWaiter {
        public ServerStateWaiter(final J2EEServerInstance instance) {
            instance.addServerListener(new J2EEServerStateListener(){

                public void serverStateChanged(J2EEServerEvent event) {
                    if (this.isInState(event)) {
                        this.onInState(instance);
                        instance.removeServerListener((J2EEServerStateListener)this);
                    }
                }
            });
        }

        protected abstract boolean isInState(J2EEServerEvent var1);

        protected abstract void onInState(J2EEServerInstance var1);
    }
}

