/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration;

import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ExternalFileDeploymentSource;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ModuleDeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentSettingsImpl
implements DeploymentSettings {
    @NonNls
    public static final String DEPLOYMENT_ELEMENT = "deployment";
    @NonNls
    public static final String SOURCE_TAG = "source";
    @NonNls
    private static final String SOURCE_TYPE_ATTRIBUTE = "type";
    private List<DeploymentModel> myDeploymentModels;
    private Project myProject;
    private final CommonStrategy myCommonStrategy;
    private final DeploymentProvider myDeploymentProvider;

    public DeploymentSettingsImpl(@NotNull Project project, @NotNull CommonStrategy commonStrategy, @NotNull DeploymentProvider deploymentProvider) {
        if (project == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(0);
        }
        if (commonStrategy == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(1);
        }
        if (deploymentProvider == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(2);
        }
        this.myDeploymentModels = new ArrayList<DeploymentModel>();
        this.myProject = project;
        this.myCommonStrategy = commonStrategy;
        this.myDeploymentProvider = deploymentProvider;
    }

    @Nullable
    public DeploymentModel getModel(@NotNull Artifact artifact) {
        if (artifact == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(3);
        }
        for (DeploymentModel model : this.myDeploymentModels) {
            DeploymentSource source = model.getDeploymentSource();
            if (!(source instanceof ArtifactDeploymentSource) || !artifact.equals(((ArtifactDeploymentSource)source).getArtifact())) continue;
            return model;
        }
        return null;
    }

    @NotNull
    public List<DeploymentModel> getDeploymentModels() {
        List<DeploymentModel> list = this.myDeploymentModels;
        if (list == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Artifact> getDeployedArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (DeploymentModel model : this.myDeploymentModels) {
            DeploymentSource source = model.getDeploymentSource();
            if (!(source instanceof ArtifactDeploymentSource)) continue;
            ContainerUtil.addIfNotNull(list, (Object)((ArtifactDeploymentSource)source).getArtifact());
        }
        ArrayList<Artifact> arrayList = list;
        if (arrayList == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<Artifact> getArtifactsToBuild() {
        List list = ContainerUtil.mapNotNull(this.myDeploymentModels, deploymentModel -> {
            DeploymentSource source = deploymentModel.getDeploymentSource();
            return source instanceof ArtifactDeploymentSource && ((ArtifactDeploymentSource)source).isBuildNeeded() ? ((ArtifactDeploymentSource)source).getArtifact() : null;
        });
        if (list == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public DeploymentModel getOrCreateModel(@NotNull Artifact artifact) {
        if (artifact == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(7);
        }
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact);
        ArtifactDeploymentSource source = JavaeeDeploymentUtil.getInstance().createArtifactDeploymentSource(pointer);
        DeploymentModel deploymentModel = this.getOrCreateModel((DeploymentSource)source);
        if (deploymentModel == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(8);
        }
        return deploymentModel;
    }

    @NotNull
    public DeploymentModel getOrCreateModel(@NotNull DeploymentSource source) {
        if (source == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(9);
        }
        for (DeploymentModel model : this.myDeploymentModels) {
            if (!model.getDeploymentSource().equals(source)) continue;
            DeploymentModel deploymentModel = model;
            if (deploymentModel == null) {
                DeploymentSettingsImpl.$$$reportNull$$$0(10);
            }
            return deploymentModel;
        }
        DeploymentModel model = this.myDeploymentProvider.createNewDeploymentModel((CommonModel)this.myCommonStrategy, source);
        this.myDeploymentModels.add(model);
        DeploymentModel deploymentModel = model;
        if (deploymentModel == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(11);
        }
        return deploymentModel;
    }

    public void removeModel(@NotNull DeploymentModel model) {
        if (model == null) {
            DeploymentSettingsImpl.$$$reportNull$$$0(12);
        }
        this.myDeploymentModels.remove(model);
    }

    public void readFrom(Element element) throws InvalidDataException {
        this.myDeploymentModels.clear();
        Element deploymentElement = element.getChild(DEPLOYMENT_ELEMENT);
        if (deploymentElement != null) {
            ArtifactPointerManager pointerManager = ArtifactPointerManager.getInstance((Project)this.myProject);
            ModulePointerManager modulePointerManager = ModulePointerManager.getInstance((Project)this.myProject);
            JavaeeDeploymentUtil deploymentUtil = JavaeeDeploymentUtil.getInstance();
            DeploymentSettingsState state = (DeploymentSettingsState)XmlSerializer.deserialize((Element)deploymentElement, DeploymentSettingsState.class);
            for (DeploymentItemState settingsState : state.getDeploymentItems()) {
                ArtifactDeploymentSource source;
                ArtifactPointer pointer;
                if (settingsState instanceof ArtifactDeploymentSettingsState) {
                    pointer = pointerManager.createPointer(((ArtifactDeploymentSettingsState)settingsState).myArtifactName);
                    source = deploymentUtil.createArtifactDeploymentSource(pointer);
                } else if (settingsState instanceof ExternalFileDeploymentSettingsState) {
                    String filePath = ((ExternalFileDeploymentSettingsState)settingsState).myFilePath;
                    source = deploymentUtil.createExternalFileDeploymentSource(new File(FileUtil.toSystemDependentName((String)filePath)));
                } else if (settingsState instanceof ModuleDeploymentSettingsState) {
                    pointer = modulePointerManager.create(((ModuleDeploymentSettingsState)settingsState).myModuleName);
                    source = deploymentUtil.createModuleDeploymentSource((ModulePointer)pointer);
                } else if (settingsState instanceof CustomDeploymentSettingsState) {
                    String typeId;
                    DeploymentSourceType<?> type;
                    final Element sourceSettings = ((CustomDeploymentSettingsState)settingsState).mySourceTag;
                    DeploymentSource customSource = null;
                    if (sourceSettings != null && (type = DeploymentSettingsImpl.findDeploymentSourceType(typeId = sourceSettings.getAttributeValue(SOURCE_TYPE_ATTRIBUTE))) != null) {
                        customSource = (DeploymentSource)new ReadAction<DeploymentSource>(){

                            protected void run(@NotNull Result<DeploymentSource> result) {
                                if (result == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                result.setResult((Object)((DeploymentSource)type.load(sourceSettings, DeploymentSettingsImpl.this.myProject)));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/run/configuration/DeploymentSettingsImpl$1", "run"));
                            }
                        }.execute().getResultObject();
                    }
                    if (customSource == null) continue;
                    source = customSource;
                } else {
                    throw new InvalidDataException("Unknown state: " + settingsState);
                }
                DeploymentModel model = this.myDeploymentProvider.createNewDeploymentModel((CommonModel)this.myCommonStrategy, (DeploymentSource)source);
                Element settings = settingsState.getSettings();
                if (settings != null) {
                    model.readExternal(settings);
                }
                this.myDeploymentModels.add(model);
            }
        }
    }

    @Nullable
    private static DeploymentSourceType<?> findDeploymentSourceType(@Nullable String id) {
        for (DeploymentSourceType type : (DeploymentSourceType[])DeploymentSourceType.EP_NAME.getExtensions()) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        return null;
    }

    public void writeTo(Element element) throws WriteExternalException {
        DeploymentSettingsState state = new DeploymentSettingsState();
        for (DeploymentModel model : this.myDeploymentModels) {
            DeploymentItemState settingsState;
            DeploymentSource source = model.getDeploymentSource();
            boolean sourceProvided = ContainerUtil.or((Iterable)this.myDeploymentProvider.getCustomDeploymentProviders(), customProvider -> customProvider.isSourceProvided(source));
            if (sourceProvided) {
                DeploymentSourceType type = source.getType();
                Element deploymentTag = new Element(SOURCE_TAG).setAttribute(SOURCE_TYPE_ATTRIBUTE, type.getId());
                type.save((com.intellij.remoteServer.configuration.deployment.DeploymentSource)source, deploymentTag);
                settingsState = new CustomDeploymentSettingsState(deploymentTag);
            } else if (source instanceof ArtifactDeploymentSource) {
                settingsState = new ArtifactDeploymentSettingsState(((ArtifactDeploymentSource)source).getArtifactPointer().getArtifactName());
            } else if (source instanceof ExternalFileDeploymentSource) {
                ExternalFileDeploymentSource externalFileSource = (ExternalFileDeploymentSource)source;
                settingsState = new ExternalFileDeploymentSettingsState(FileUtil.toSystemIndependentName((String)externalFileSource.getFilePath()));
            } else if (source instanceof ModuleDeploymentSource) {
                ModuleDeploymentSource moduleSource = (ModuleDeploymentSource)source;
                settingsState = new ModuleDeploymentSettingsState(moduleSource.getModulePointer().getModuleName());
            } else {
                throw new WriteExternalException("Unknown source: " + source);
            }
            Element settings = new Element("settings");
            model.writeExternal(settings);
            settingsState.setSettings(settings);
            state.getDeploymentItems().add(settingsState);
        }
        Element content = XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(content);
    }

    public void setModels(List<DeploymentModel> models) {
        this.myDeploymentModels.clear();
        this.myDeploymentModels.addAll(models);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/run/configuration/DeploymentSettingsImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = SOURCE_TAG;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/run/configuration/DeploymentSettingsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployedArtifacts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsToBuild";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="custom")
    public static class CustomDeploymentSettingsState
    extends DeploymentItemState {
        @Tag(value="source")
        public Element mySourceTag;

        public CustomDeploymentSettingsState() {
        }

        public CustomDeploymentSettingsState(Element sourceTag) {
            this.mySourceTag = sourceTag;
        }
    }

    @Tag(value="module")
    public static class ModuleDeploymentSettingsState
    extends DeploymentItemState {
        @Attribute(value="name")
        public String myModuleName;

        public ModuleDeploymentSettingsState() {
        }

        public ModuleDeploymentSettingsState(String artifactName) {
            this.myModuleName = artifactName;
        }
    }

    @Tag(value="artifact")
    public static class ArtifactDeploymentSettingsState
    extends DeploymentItemState {
        @Attribute(value="name")
        public String myArtifactName;

        public ArtifactDeploymentSettingsState() {
        }

        public ArtifactDeploymentSettingsState(String artifactName) {
            this.myArtifactName = artifactName;
        }
    }

    @Tag(value="file")
    public static class ExternalFileDeploymentSettingsState
    extends DeploymentItemState {
        @Attribute(value="path")
        public String myFilePath;

        public ExternalFileDeploymentSettingsState() {
        }

        public ExternalFileDeploymentSettingsState(String filePath) {
            this.myFilePath = filePath;
        }
    }

    public static abstract class DeploymentItemState {
        private Element mySettings;

        @Tag(value="settings")
        public Element getSettings() {
            return this.mySettings;
        }

        public void setSettings(Element settings) {
            this.mySettings = settings;
        }
    }

    @Tag(value="deployment")
    public static class DeploymentSettingsState {
        private List<DeploymentItemState> myDeploymentItems = new ArrayList<DeploymentItemState>();

        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTypes={ExternalFileDeploymentSettingsState.class, ArtifactDeploymentSettingsState.class, ModuleDeploymentSettingsState.class, CustomDeploymentSettingsState.class})
        public List<DeploymentItemState> getDeploymentItems() {
            return this.myDeploymentItems;
        }

        public void setDeploymentItems(List<DeploymentItemState> deploymentItems) {
            this.myDeploymentItems = deploymentItems;
        }
    }
}

