/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.server;

import com.intellij.javaee.process.JavaeeProcessObjectListener;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodParamSaver;
import com.intellij.javaee.process.common.MethodResultSerializer;
import com.intellij.javaee.process.common.OutputWriter;
import com.intellij.javaee.process.server.ResponseDocumentWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaeeProcessObjectListenerBase<T extends JavaeeProcessObjectListener> {
    private final Class<T> myListenerInterface;
    private final OutputWriter myOutputWriter;
    private final String myListenerId;
    private final MethodResultSerializer myListenerParamSerializer;
    private final T myProxy;

    public JavaeeProcessObjectListenerBase(Class<T> listenerInterface, OutputWriter outputWriter, String listenerId) {
        this.myListenerInterface = listenerInterface;
        this.myOutputWriter = outputWriter;
        this.myListenerId = listenerId;
        this.myListenerParamSerializer = new MethodResultSerializer();
        this.myProxy = (JavaeeProcessObjectListener)listenerInterface.cast(Proxy.newProxyInstance(listenerInterface.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)new InvocationHandlerImpl()));
    }

    protected MethodResultSerializer getListenerParamSerializer() {
        return this.myListenerParamSerializer;
    }

    protected final T getProxy() {
        return this.myProxy;
    }

    protected abstract void handleInvocationException(JavaeeProcessUtilException var1);

    private class InvocationHandlerImpl
    implements InvocationHandler {
        private InvocationHandlerImpl() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                String listenerMethodName = method.getName();
                Document responseDocument = OutputWriter.createDocument();
                ResponseDocumentWrapper responseWrapper = new ResponseDocumentWrapper(responseDocument);
                responseWrapper.setCause("listener");
                responseWrapper.createTopElement("listenerClassName", JavaeeProcessObjectListenerBase.this.myListenerInterface.getName());
                responseWrapper.createTopElement("listenerObjectId", JavaeeProcessObjectListenerBase.this.myListenerId);
                responseWrapper.createTopElement("listenerMethodName", listenerMethodName);
                new MethodParamSaver(JavaeeProcessObjectListenerBase.this.myListenerInterface, listenerMethodName, JavaeeProcessObjectListenerBase.this.myListenerParamSerializer.serializeArgs(args)).save(responseWrapper);
                JavaeeProcessObjectListenerBase.this.myOutputWriter.putDocument(responseDocument);
            }
            catch (JavaeeProcessUtilException e) {
                JavaeeProcessObjectListenerBase.this.handleInvocationException(e);
            }
            return null;
        }
    }
}

