/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.JavaeeProcessObject;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodWrapper {
    private final Method myTargetMethod;
    private final int myParamCount;
    private final String[] myParamNames;

    public MethodWrapper(Class<? extends JavaeeProcessObject> targetClass, String methodName) throws JavaeeProcessUtilException {
        Method targetMethod = null;
        for (Method method : targetClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod == null) {
            throw new JavaeeProcessUtilException("Unknown method: " + methodName);
        }
        this.myTargetMethod = targetMethod;
        Annotation[][] annotations = targetMethod.getParameterAnnotations();
        this.myParamCount = annotations.length;
        this.myParamNames = new String[this.myParamCount];
        for (int iParam = 0; iParam < this.myParamCount; ++iParam) {
            String paramName;
            this.myParamNames[iParam] = paramName = "ParamName#" + iParam;
        }
    }

    public Method getTargetMethod() {
        return this.myTargetMethod;
    }

    public int getParamCount() {
        return this.myParamCount;
    }

    public void iterateParams(ParamProcessor paramProcessor) {
        for (int iParam = 0; iParam < this.myParamNames.length; ++iParam) {
            paramProcessor.processParam(iParam, this.myParamNames[iParam]);
        }
    }

    public static interface ParamProcessor {
        public void processParam(int var1, String var2);
    }
}

