/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessConnection;
import com.intellij.javaee.process.JavaeeProcessObjectListener;
import com.intellij.javaee.process.JavaeeProcessResponseToListener;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodInvocator;
import com.intellij.javaee.process.common.MethodParamDeserializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import java.util.HashMap;
import java.util.Map;

public class JavaeeProcessListenerRegistry
extends AbstractResponseHandler<JavaeeProcessResponseToListener> {
    private static final Logger LOG = Logger.getInstance(JavaeeProcessListenerRegistry.class);
    private Map<Integer, JavaeeProcessObjectListener> myId2Listener = new HashMap<Integer, JavaeeProcessObjectListener>();
    private final ClassLoader myListenersClassLoader;
    private int myNextId = 0;

    public JavaeeProcessListenerRegistry(JavaeeProcessConnection connection, ClassLoader listenersClassLoader) {
        this.myListenersClassLoader = listenersClassLoader;
        connection.getSocketConnection().registerHandler(JavaeeProcessResponseToListener.class, (AbstractResponseHandler)this);
    }

    public void processResponse(JavaeeProcessResponseToListener response) {
        try {
            MethodInvocator.invoke(this.myListenersClassLoader.loadClass(response.getListenerClassName()), this.myId2Listener.get(response.getListenerObjectId()), response.getListenerMethodName(), response.getParamProvider(), new MethodParamDeserializer());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
        catch (JavaeeProcessUtilException e) {
            LOG.error((Throwable)e);
        }
    }

    public int registerListener(JavaeeProcessObjectListener listener) {
        int result = this.myNextId++;
        this.myId2Listener.put(result, listener);
        return result;
    }
}

