/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessConnectionException;
import com.intellij.javaee.process.JavaeeProcessExternalizerFactory;
import com.intellij.javaee.process.JavaeeProcessListenerRegistry;
import com.intellij.javaee.process.JavaeeProcessRequest;
import com.intellij.javaee.process.JavaeeProcessResponse;
import com.intellij.javaee.process.JavaeeProcessResponseToRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponseToRequestHandler;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.SocketConnection;
import com.intellij.util.io.socketConnection.SocketConnectionFactory;
import java.io.IOException;

public class JavaeeProcessConnection {
    private static final Logger LOG = Logger.getInstance(JavaeeProcessConnection.class);
    private static final int TIME_OUT_MSECS = 90000;
    private static final int POLL_CONNECTION_MSECS = 500;
    private static final String TIMEOUT_VM_OPTION_NAME = "idea.javaee.client.process.timeout";
    private final SocketConnection<JavaeeProcessRequest, JavaeeProcessResponse> myConnection = SocketConnectionFactory.createServerConnection((int)0, (RequestResponseExternalizerFactory)new JavaeeProcessExternalizerFactory());
    private final JavaeeProcessListenerRegistry myListenerRegistry;

    public JavaeeProcessConnection(ClassLoader listenersClassLoader) throws IOException {
        this.myConnection.open();
        this.myListenerRegistry = new JavaeeProcessListenerRegistry(this, listenersClassLoader);
    }

    public SocketConnection<JavaeeProcessRequest, JavaeeProcessResponse> getSocketConnection() {
        return this.myConnection;
    }

    public JavaeeProcessResponseToRequest requestAndWaitForResponse(JavaeeProcessRequest request) throws JavaeeProcessConnectionException {
        int time;
        final Ref responseRef = new Ref();
        final Semaphore responseSemaphore = new Semaphore();
        responseSemaphore.down();
        this.myConnection.sendRequest((AbstractRequest)request, (AbstractResponseToRequestHandler)new AbstractResponseToRequestHandler<JavaeeProcessResponseToRequest>(){

            public boolean processResponse(JavaeeProcessResponseToRequest response) {
                LOG.debug("Response: " + response);
                responseRef.set((Object)response);
                responseSemaphore.up();
                return true;
            }
        });
        int timeOutMsecs = SystemProperties.getIntProperty((String)TIMEOUT_VM_OPTION_NAME, (int)90000);
        LOG.debug("Start waiting for response, socket timeout: " + timeOutMsecs);
        for (time = 0; responseRef.isNull() && time < timeOutMsecs; time += 500) {
            if (this.myConnection.isStopping()) {
                throw new JavaeeProcessConnectionException("SocketConnection was closed before response was received");
            }
            responseSemaphore.waitFor(500L);
        }
        LOG.debug("Finish waiting for response, total time: " + time);
        if (responseRef.isNull()) {
            throw new JavaeeProcessConnectionException("SocketConnection timeout");
        }
        return (JavaeeProcessResponseToRequest)responseRef.get();
    }

    public void requestAsynchronously(JavaeeProcessRequest request) {
        this.myConnection.sendRequest((AbstractRequest)request);
    }

    public void close() {
        this.myConnection.close();
    }

    public boolean isClosed() {
        return this.myConnection.isStopping();
    }

    public JavaeeProcessListenerRegistry getListenerRegistry() {
        return this.myListenerRegistry;
    }
}

