/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DefaultJSPPositionManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.server.DeploymentStatusManager;
import com.intellij.javaee.oss.server.DisposablePositionManager;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHomeProvider;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.oss.server.JavaeeServerVersionProvider;
import com.intellij.javaee.oss.server.async.JavaeeAsyncLocalInstance;
import com.intellij.javaee.oss.server.async.JavaeeAsyncRemoteInstance;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.PredefinedLogFilesProvider;
import com.intellij.javaee.run.configuration.ServerModelEx;
import com.intellij.javaee.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeServerModel
extends ServerModelEx
implements PredefinedLogFilesProvider {
    private static final Logger LOG = Logger.getInstance(JavaeeServerModel.class);
    @NonNls
    public String USERNAME = this.getDefaultUsername();
    @NonNls
    public String PASSWORD = this.getDefaultPassword();
    private CommonModel config;

    public void setCommonModel(CommonModel config) {
        this.config = config;
    }

    public JavaeeIntegration getIntegration() {
        return (JavaeeIntegration)this.config.getIntegration();
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        try {
            JavaeeIntegration integration = this.getIntegration();
            String home = this.getHome();
            LOG.debug("createServerInstance::home = " + home);
            ApplicationServerPersistentData persistentData = this.getCommonModel().getApplicationServer().getPersistentData();
            if (persistentData instanceof JavaeePersistentData) {
                integration.detectVersion((JavaeePersistentData)persistentData);
            }
            DeploymentStatusManager deploymentStatusManager = new DeploymentStatusManager();
            JavaeeServerInstanceImpl pureInstance = new JavaeeServerInstanceImpl(this.config, deploymentStatusManager);
            DefaultServerInstance result = integration.isAsyncWrapped() ? (this.isLocal() ? new JavaeeAsyncLocalInstance(pureInstance, deploymentStatusManager) : new JavaeeAsyncRemoteInstance(pureInstance, deploymentStatusManager)) : pureInstance;
            deploymentStatusManager.setServerInstance((J2EEServerInstance)result);
            return result;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected final boolean isLocal() {
        return this.config.isLocal();
    }

    public DeploymentProvider getDeploymentProvider() {
        return null;
    }

    public int getDefaultPort() {
        return 8080;
    }

    public int getLocalPort() {
        return this.getDefaultPort();
    }

    public int getPingPort() {
        return this.getServerPort();
    }

    @NotNull
    public String getDefaultUrlForBrowser() {
        String string = this.getIntegration().getDeployedFileUrlProvider().getDefaultUrlForServerConfig(this.config);
        if (string == null) {
            JavaeeServerModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public OutputProcessor createOutputProcessor(ProcessHandler handler, J2EEServerInstance instance) {
        return new DefaultOutputProcessor(handler);
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        ArrayList<Pair<String, Integer>> addressesToCheck = new ArrayList<Pair<String, Integer>>();
        if (this.isLocal()) {
            String serverHost = this.getServerHost();
            addressesToCheck.add((Pair<String, Integer>)new Pair((Object)serverHost, (Object)this.getServerPort()));
            addressesToCheck.add((Pair<String, Integer>)new Pair((Object)serverHost, (Object)this.getLocalPort()));
        }
        return addressesToCheck;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!this.isEmptyPasswordAllowed() && StringUtil.isNotEmpty((String)this.USERNAME) && StringUtil.isEmpty((String)this.PASSWORD)) {
            throw new RuntimeConfigurationError(JavaeeBundle.getText("ServerModel.password", new Object[0]));
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getHome() {
        return new JavaeeServerHomeProvider(this).getValue();
    }

    public String getVersion() {
        return new JavaeeServerVersionProvider(this).getValue();
    }

    public String getVmArguments() {
        return this.config instanceof CommonStrategy ? ((CommonStrategy)this.config).getSettingsBean().COMMON_VM_ARGUMENTS : "";
    }

    @NonNls
    private static String getVmArgumentPrefix(String name) {
        return "-D" + name + "=";
    }

    @NonNls
    private String[] getVmArgumentsList() {
        return this.getVmArguments().split("\\s+");
    }

    @Nullable
    public String getVmArgument(String name) {
        String prefix = JavaeeServerModel.getVmArgumentPrefix(name);
        for (String arg : this.getVmArgumentsList()) {
            if (!arg.startsWith(prefix)) continue;
            return StringUtil.unquoteString((String)arg.substring(prefix.length()));
        }
        return null;
    }

    public void setVmArgument(String name, String value) {
        if (!(this.config instanceof CommonStrategy)) {
            return;
        }
        String prefix = JavaeeServerModel.getVmArgumentPrefix(name);
        String newArg = value == null ? null : prefix + value;
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : this.getVmArgumentsList()) {
            if (arg.startsWith(prefix)) {
                if (newArg == null) continue;
                newArgs.add(newArg);
                newArg = null;
                continue;
            }
            newArgs.add(arg);
        }
        if (newArg != null) {
            newArgs.add(newArg);
        }
        ((CommonStrategy)this.config).getSettingsBean().COMMON_VM_ARGUMENTS = StringUtil.join(newArgs, (String)" ");
    }

    protected boolean isEmptyPasswordAllowed() {
        return false;
    }

    @NonNls
    protected abstract String getDefaultUsername();

    @NonNls
    protected abstract String getDefaultPassword();

    protected abstract int getServerPort();

    protected abstract JavaeeAdmin createServerAdmin(JavaeeServerInstance var1) throws Exception;

    protected String getServerHost() {
        return this.config.getHost();
    }

    public CommonModel getCommonModel() {
        return this.config;
    }

    protected List<File> getLibraries() throws ExecutionException {
        ArrayList<File> libraries = new ArrayList<File>();
        for (VirtualFile file : this.config.getApplicationServer().getLibrary().getFiles(OrderRootType.CLASSES)) {
            libraries.add(new File(file.getPresentableUrl()));
        }
        return libraries;
    }

    public File getPathUnderHome(String relativePath) {
        return new JavaeeServerHomeProvider(this).getPathUnderHome(relativePath);
    }

    @NotNull
    public PredefinedLogFile[] getPredefinedLogFiles() {
        ArrayList<PredefinedLogFile> result = new ArrayList<PredefinedLogFile>();
        for (LogFileFactory factory : this.getLogFileFactories()) {
            result.add(factory.createPredefinedLogFile());
        }
        PredefinedLogFile[] predefinedLogFileArray = result.toArray(new PredefinedLogFile[result.size()]);
        if (predefinedLogFileArray == null) {
            JavaeeServerModel.$$$reportNull$$$0(1);
        }
        return predefinedLogFileArray;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile file) {
        for (LogFileFactory factory : this.getLogFileFactories()) {
            LogFileOptions result = factory.createOptions(file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected List<LogFileFactory> getLogFileFactories() {
        return Collections.singletonList(new DefaultLogFileFactory());
    }

    @Nullable
    protected String getLogFilePath(String home) {
        return null;
    }

    protected boolean isTruncateLogFile() {
        return false;
    }

    public void updateChangedFiles(Set<String> changedFilesPaths) {
    }

    protected PositionManager createPositionManager(DebugProcess process, JavaeeFacet[] scopeFacetsWithIncluded) {
        return new DefaultJSPPositionManager(process, scopeFacetsWithIncluded){

            @NonNls
            protected String getGeneratedClassesPackage() {
                return "org.apache.jsp";
            }
        };
    }

    public boolean undeployBeforeDeploy(DeploymentModel deploymentModel) {
        return this.undeployBeforeDeploy();
    }

    public boolean undeployBeforeDeploy() {
        return true;
    }

    public void initProcessDebug(ProcessHandler handler) {
        final CommonModel commonModel = this.getCommonModel();
        DebuggerManager.getInstance((Project)commonModel.getProject()).addDebugProcessListener(handler, new DebugProcessListener(){
            PositionManager myPositionManager;

            public void processAttached(DebugProcess process) {
                this.myPositionManager = JavaeeServerModel.this.createPositionManager(process, DefaultServerInstance.getScopeFacetsWithIncluded((CommonModel)commonModel));
                process.appendPositionManager(this.myPositionManager);
            }

            public void processDetached(DebugProcess process, boolean closedByUser) {
                if (this.myPositionManager instanceof DisposablePositionManager) {
                    ((DisposablePositionManager)this.myPositionManager).dispose();
                }
            }
        });
    }

    public boolean isDetectableLocalPort() {
        return true;
    }

    public boolean isDetectableServerPort() {
        return true;
    }

    public Sdk getJre() {
        return ((CommonStrategy)this.config).getJre();
    }

    public String getJrePath() {
        Sdk jre = this.getJre();
        if (jre == null) {
            return null;
        }
        String jrePath = jre.getHomePath();
        return jrePath == null ? null : FileUtil.toSystemDependentName((String)jrePath);
    }

    protected void checkHasJdk() throws RuntimeConfigurationError {
        if (this.getJre() == null) {
            throw new RuntimeConfigurationError(this.getJdkRequiredMessage());
        }
    }

    protected void checkJdkAtMost7() throws RuntimeConfigurationError {
        JavaSdkVersion sdkVersion;
        Sdk jre = this.getJre();
        if (jre != null && (sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jre)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            throw new RuntimeConfigurationError(this.getJdkTooNewMessage());
        }
    }

    protected String getJdkTooNewMessage() {
        return this.isLocal() ? JavaeeBundle.getText("JavaeeServerModel.local.error.runtime.jdk.too.new", new Object[0]) : JavaeeBundle.getText("JavaeeServerModel.remote.error.runtime.jdk.too.new", new Object[0]);
    }

    protected void checkJdkAtLeast7() throws RuntimeConfigurationError {
        this.doCheckJdkAtLeast(JavaSdkVersion.JDK_1_7);
    }

    protected void doCheckJdkAtLeast(JavaSdkVersion jdkVersion) throws RuntimeConfigurationError {
        Sdk jre = this.getJre();
        JavaSdkVersion sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jre);
        if (sdkVersion != null && !sdkVersion.isAtLeast(jdkVersion)) {
            throw new RuntimeConfigurationError(this.getJdkTooOldMessage(jdkVersion.getDescription()));
        }
    }

    protected String getJdkTooOldMessage(String version) {
        return this.isLocal() ? JavaeeBundle.getText("JavaeeServerModel.local.error.runtime.jdk.too.old", version) : JavaeeBundle.getText("JavaeeServerModel.remote.error.runtime.jdk.too.old", version);
    }

    protected String getJdkRequiredMessage() {
        return this.isLocal() ? JavaeeBundle.getText("JavaeeServerModel.local.error.runtime.jdk.required", new Object[0]) : JavaeeBundle.getText("JavaeeServerModel.remote.error.runtime.jdk.required", new Object[0]);
    }

    public String getServerSpecificContext(DeploymentModel model) {
        File source = model.getDeploymentSource().getFile();
        return source == null ? null : this.getServerSpecificContext(source);
    }

    public String getServerSpecificContext(File source) {
        return source.getName();
    }

    public static String cutWarExtension(File source) {
        return FileUtilRt.extensionEquals((String)source.getName(), (String)"war") ? FileUtil.getNameWithoutExtension((File)source) : source.getName();
    }

    @NonNls
    protected abstract String getLogFileId();

    public boolean isPingSupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/oss/server/JavaeeServerModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrlForBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected class DefaultLogFileFactory
    extends LogFileFactory {
        protected DefaultLogFileFactory() {
        }

        @Override
        protected String getId() {
            return JavaeeServerModel.this.getLogFileId();
        }

        @Override
        protected String getPath() {
            return JavaeeServerModel.this.getLogFilePath(JavaeeServerModel.this.getHome());
        }
    }

    protected static abstract class LogFileFactory {
        private final boolean myEnabled;

        protected LogFileFactory(boolean enabled) {
            this.myEnabled = enabled;
        }

        protected LogFileFactory() {
            this(true);
        }

        protected LogFileOptions createOptions(PredefinedLogFile file) {
            String path;
            if (this.getId().equals(file.getId()) && (path = this.getPath()) != null) {
                String name = JavaeeBundle.getText("ServerModel.logfile", this.getName());
                return new LogFileOptions(name, path, file.isEnabled(), true, false);
            }
            return null;
        }

        public PredefinedLogFile createPredefinedLogFile() {
            return new PredefinedLogFile(this.getId(), this.myEnabled);
        }

        protected String getName() {
            return this.getId();
        }

        protected abstract String getId();

        protected abstract String getPath();
    }
}

