/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.run.configuration.J2EEConfigurationType;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeConfigurationType
extends J2EEConfigurationType
implements ConfigurationType {
    private JavaeeIntegration myIntegration;

    public JavaeeConfigurationType(JavaeeIntegration integration) {
        this.myIntegration = integration;
    }

    private JavaeeIntegration doGetIntegration() {
        return this.myIntegration;
    }

    public Icon getIcon() {
        return this.doGetIntegration().getIcon();
    }

    public String getDisplayName() {
        return JavaeeBundle.getText("ConfigurationType.name", this.doGetIntegration().getName());
    }

    public String getConfigurationTypeDescription() {
        return JavaeeBundle.getText("ConfigurationType.description", this.doGetIntegration().getName());
    }

    public AppServerIntegration getIntegration() {
        return this.doGetIntegration();
    }

    protected RunConfiguration createJ2EEConfigurationTemplate(ConfigurationFactory factory, Project project, boolean isLocal) {
        AppServerIntegration integration = this.getIntegration();
        ServerModel model = isLocal ? this.createLocalModel() : this.createRemoteModel();
        J2EEConfigurationFactory configurationFactory = J2EEConfigurationFactory.getInstance();
        if (!isLocal) {
            return configurationFactory.createJ2EERunConfiguration(factory, project, model, integration, false, (ExecutableObjectStartupPolicy)null);
        }
        if (this.isJavaStartupPolicy()) {
            return configurationFactory.createJ2EERunConfiguration(factory, project, model, integration, true, this.createJavaStartupPolicy());
        }
        return configurationFactory.createJ2EERunConfiguration(factory, project, model, integration, true, this.createStartupPolicy());
    }

    @NotNull
    protected abstract ServerModel createLocalModel();

    @NotNull
    protected abstract ServerModel createRemoteModel();

    @NotNull
    protected abstract ExecutableObjectStartupPolicy createStartupPolicy();

    @NotNull
    protected JavaCommandLineStartupPolicy createJavaStartupPolicy() {
        throw new UnsupportedOperationException();
    }

    protected boolean isJavaStartupPolicy() {
        return false;
    }
}

