/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.descriptor;

import com.intellij.facet.FacetManager;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptor;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeFileDescription<T extends JavaeeDomModelElement>
extends DomFileDescription<T> {
    private final JavaeeDescriptor myDescriptor;

    public JavaeeFileDescription(Class<T> type, @NonNls String root, JavaeeIntegration integration) {
        super(type, root, new String[0]);
        this.myDescriptor = integration.getDescriptorsManager().getItem(type);
    }

    protected void initializeFileDescription() {
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            JavaeeFileDescription.$$$reportNull$$$0(0);
        }
        return this.checkMatchingNamespace(file) && this.checkMatchingFacet(file);
    }

    private boolean checkMatchingNamespace(XmlFile file) {
        XmlDocument document;
        if (file.isValid() && (document = file.getDocument()) != null) {
            XmlTag tag = document.getRootTag();
            return tag != null && this.getRootTagName().equals(tag.getLocalName()) && this.myDescriptor.hasNamespace(tag.getNamespace());
        }
        return false;
    }

    private boolean checkMatchingFacet(XmlFile file) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null && !FacetManager.getInstance((Module)module).getFacetsByType(this.myDescriptor.getFacetType()).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/oss/descriptor/JavaeeFileDescription", "isMyFile"));
    }
}

