/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.agent;

import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.annotation.FinalCall;
import com.intellij.remoteServer.agent.impl.CallerClassLoaderProvider;
import com.intellij.remoteServer.agent.impl.ChildWrapperCreator;
import com.intellij.remoteServer.agent.impl.RemoteAgentProxyFactoryBase;
import com.intellij.remoteServer.agent.impl.RemoteAgentThreadProxyFactory;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ContextThreadAgentProxyFactory
extends RemoteAgentThreadProxyFactory
implements AgentProxyFactory {
    public ContextThreadAgentProxyFactory() {
        this((ClassLoader)null);
    }

    public ContextThreadAgentProxyFactory(@Nullable ClassLoader callerClassLoader) {
        this(new CallerClassLoaderProvider(callerClassLoader));
    }

    private ContextThreadAgentProxyFactory(CallerClassLoaderProvider callerClassLoaderProvider) {
        super(callerClassLoaderProvider, (RemoteAgentProxyFactory)new ContextThreadAgentProxyFactoryDelegate(callerClassLoaderProvider), new ChildWrapperCreator(){

            public InvocationHandler createWrapperInvocationHandler(final Object child) {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        Class<?> childClass = child.getClass();
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class[] delegateParameterTypes = new Class[parameterTypes.length];
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            delegateParameterTypes[i] = childClass.getClassLoader().loadClass(parameterTypes[i].getName());
                        }
                        Method delegateMethod = childClass.getMethod(method.getName(), delegateParameterTypes);
                        return delegateMethod.invoke(child, args);
                    }
                };
            }
        });
    }

    private static class ContextThreadAgentProxyFactoryDelegate
    implements RemoteAgentProxyFactory {
        private final CallerClassLoaderProvider myCallerClassLoaderProvider;

        public ContextThreadAgentProxyFactoryDelegate(CallerClassLoaderProvider callerClassLoaderProvider) {
            this.myCallerClassLoaderProvider = callerClassLoaderProvider;
        }

        public <T> T createProxy(List<File> libraries, Class<T> agentInterface, String agentClassName) throws Exception {
            return (T)new RemoteAgentProxyFactoryBase(this.myCallerClassLoaderProvider){

                protected ClassLoader createAgentClassLoader(URL[] agentLibraryUrls) {
                    return new URLClassLoader(agentLibraryUrls, ((Object)((Object)this)).getClass().getClassLoader());
                }

                protected InvocationHandler createInvocationHandler(final Object agentImpl, final ClassLoader agentClassLoader, ClassLoader callerClassLoader) {
                    return new InvocationHandler(){
                        ClassLoader myInitialClassLoader;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            boolean finalCall;
                            Object object;
                            if (this.myInitialClassLoader == null) {
                                this.myInitialClassLoader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(agentClassLoader);
                            }
                            try {
                                object = method.invoke(agentImpl, args);
                                boolean bl = finalCall = method.getAnnotation(FinalCall.class) != null;
                            }
                            catch (Throwable throwable) {
                                boolean finalCall2;
                                boolean bl = finalCall2 = method.getAnnotation(FinalCall.class) != null;
                                if (finalCall2) {
                                    Thread.currentThread().setContextClassLoader(this.myInitialClassLoader);
                                }
                                throw throwable;
                            }
                            if (finalCall) {
                                Thread.currentThread().setContextClassLoader(this.myInitialClassLoader);
                            }
                            return object;
                        }
                    };
                }
            }.createProxy(libraries, agentInterface, agentClassName);
        }
    }
}

