/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditWebRootDialog
extends DialogWrapper {
    private JPanel myPanel;
    private FieldPanel myRootField;
    private final List<WebRootData> myExistingRoots;
    private JTextField myURI;
    private JLabel myURILabel;
    private final Project myProject;
    private final Module myModule;

    public EditWebRootDialog(final Project project, WebRootData webRoot, boolean enablePathField, final Module module, List<WebRootData> existingRoots) {
        super(project, false);
        this.myProject = project;
        this.myModule = module;
        this.myExistingRoots = existingRoots;
        this.$$$setupUI$$$();
        ActionListener browseButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile initialDir;
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setTitle(J2EEBundle.message((String)"dialog.title.web.resource.directory", (Object[])new Object[0]));
                descriptor.setDescription(J2EEBundle.message((String)"dialog.description.web.resource.directory", (Object[])new Object[0]));
                descriptor.setRoots(ModuleRootManager.getInstance((Module)module).getContentRoots());
                String oldPath = EditWebRootDialog.this.myRootField.getText();
                if (oldPath != null && oldPath.length() != 0) {
                    File oldFile = new File(oldPath);
                    initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile);
                } else {
                    initialDir = null;
                }
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, initialDir, file -> EditWebRootDialog.this.myRootField.setText(FileUtil.toSystemDependentName((String)file.getPath())));
            }
        };
        this.myRootField.setLabelText(J2EEBundle.message((String)"label.new.web.root.web.resource.directory.path", (Object[])new Object[0]));
        this.myRootField.setBrowseButtonActionListener(browseButtonActionListener);
        this.myRootField.createComponent();
        if (webRoot != null) {
            this.myRootField.setText(FileUtil.toSystemDependentName((String)PathUtil.toPresentableUrl((String)webRoot.getUrl())));
            this.myURI.setText(webRoot.getRelativePath());
        } else {
            this.myURI.setText("/");
        }
        this.myURILabel.setLabelFor(this.myURI);
        this.myRootField.setEnabled(enablePathField);
        this.setTitle(J2EEBundle.message((String)"dialog.title.web.resource.directory.path", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return new JPanel();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            EditWebRootDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("project.creatingModules.resourceWeb");
    }

    protected void doOKAction() {
        VirtualFile[] contentRoots;
        final VirtualFile[] file = new VirtualFile[]{this.getFile()};
        if (file[0] == null) {
            final String path = this.myRootField.getText();
            int ret = Messages.showYesNoDialog((String)J2EEBundle.message((String)"confirmation.text.create.directory", (Object[])new Object[]{path}), (String)J2EEBundle.message((String)"message.title.directory.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            final IOException[] exception = new IOException[]{null};
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    file[0] = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                        public VirtualFile compute() {
                            try {
                                File ioFile = new File(path);
                                FileUtil.createParentDirs((File)ioFile);
                                File parentFile = ioFile.getParentFile();
                                if (parentFile == null) {
                                    return null;
                                }
                                VirtualFile parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
                                if (parent == null) {
                                    return null;
                                }
                                return parent.createChildDirectory((Object)this, ioFile.getName());
                            }
                            catch (IOException e) {
                                exception[0] = e;
                                return null;
                            }
                        }
                    });
                }
            }, J2EEBundle.message((String)"command.name.creating.web.root.dir", (Object[])new Object[0]), (Object)this);
            if (exception[0] != null || file[0] == null) {
                String message = exception[0] == null ? "" : exception[0].getMessage();
                Messages.showErrorDialog((String)J2EEBundle.message((String)"message.text.error.creating.directory", (Object[])new Object[]{message}), (String)J2EEBundle.message((String)"message.title.error", (Object[])new Object[0]));
                return;
            }
        }
        if (!EditWebRootDialog.isFileUnder(file[0], contentRoots = ModuleRootManager.getInstance((Module)this.myModule).getContentRoots())) {
            Messages.showErrorDialog((String)J2EEBundle.message((String)"message.text.web.resource.directory.should.be.located.under.module.root", (Object[])new Object[0]), (String)J2EEBundle.message((String)"message.title.directory.not.in.module", (Object[])new Object[0]));
            return;
        }
        for (WebRootData existingRoot : this.myExistingRoots) {
            VirtualFile existingFile = existingRoot.findFile();
            if (existingFile == null) continue;
            if (VfsUtilCore.isAncestor((VirtualFile)existingFile, (VirtualFile)file[0], (boolean)false)) {
                Messages.showErrorDialog((String)J2EEBundle.message((String)"message.text.existing.web.resource.directory.configured.in.dir.which.includes.dir", (Object[])new Object[]{FileUtil.toSystemDependentName((String)existingFile.getPath()), FileUtil.toSystemDependentName((String)file[0].getPath())}), (String)J2EEBundle.message((String)"message.title.conflicting.directory.found", (Object[])new Object[0]));
                return;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)file[0], (VirtualFile)existingFile, (boolean)false)) continue;
            Messages.showErrorDialog((String)J2EEBundle.message((String)"message.text.existing.web.resource.directory.configured.in.dir.which.will.be.included.in.dir", (Object[])new Object[]{FileUtil.toSystemDependentName((String)existingFile.getPath()), FileUtil.toSystemDependentName((String)file[0].getPath())}), (String)J2EEBundle.message((String)"message.title.conflicting.directory.found", (Object[])new Object[0]));
            return;
        }
        super.doOKAction();
    }

    private static boolean isFileUnder(VirtualFile file, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public WebRootData saveWebRoot() {
        VirtualFile file = this.getFile();
        if (file == null) {
            Messages.showErrorDialog((String)J2EEBundle.message((String)"message.text.cannot.find.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)this.myRootField.getText())}), (String)J2EEBundle.message((String)"message.title.file.not.found", (Object[])new Object[0]));
            return null;
        }
        return new WebRootData(file.getUrl(), this.myURI.getText());
    }

    @Nullable
    private VirtualFile getFile() {
        String path = FileUtil.toSystemIndependentName((String)this.myRootField.getText());
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.javaee.module.view.web.EditWebRootDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRootField.isEnabled() ? this.myRootField.getTextField() : this.myURI;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/web/EditWebRootDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        FieldPanel fieldPanel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRootField = fieldPanel = new FieldPanel();
        jPanel.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myURILabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.web.root.dialog.relative.path.in.deployment.directory"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURI = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

