/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.references;

import com.intellij.ide.DataManager;
import com.intellij.ide.TypePresentationService;
import com.intellij.jam.JamMessages;
import com.intellij.jam.model.common.CommonDomModelElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.module.view.ejb.references.Section;
import com.intellij.javaee.ui.DefaultUserResponse;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.AbstractTableView;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.DomCollectionControl;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SectionTableView
implements CommittablePanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.module.view.ejb.references.SectionTableView");
    private static final int ADD_SHORTCUT = 155;
    private static final int EDIT_SHORTCUT = 115;
    private static final int DELETE_SHORTCUT = 127;
    private static final Cursor ourResizeCursor = Cursor.getPredefinedCursor(11);
    private final JTableHeader myTableHeader;
    private final Project myProject;
    private final Section[] mySections;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final List<RowElement> myData = new ArrayList<RowElement>();
    private final Set<Section> myExpandedSections = new HashSet<Section>();
    private final Map<Section, ColumnInfo<CommonDomModelElement, Object>[]> myColumnInfos = new HashMap();
    private static final ColumnInfo<CommonDomModelElement, Object> MOCK_COLUMN_INFO = new ColumnInfo<CommonDomModelElement, Object>(null){
        private final DefaultTableCellRenderer myCellRenderer = new DefaultTableCellRenderer();

        public Object valueOf(CommonDomModelElement item) {
            return "";
        }

        public TableCellRenderer getRenderer(CommonDomModelElement item) {
            return this.myCellRenderer;
        }
    };
    private final MyDomTableView myDomTableView;
    private final ColumnInfo[] myTableColumnInfos;

    public SectionTableView(Project project, Section ... sections) {
        this(project, (String)null, sections);
    }

    public SectionTableView(Project project, String helpId, Section ... sections) {
        this.myProject = project;
        this.mySections = sections;
        this.myDomTableView = new MyDomTableView(project, helpId);
        this.myDomTableView.addChangeListener(new AbstractTableView.ChangeListener(){

            public void changed() {
                SectionTableView.this.reset();
            }
        });
        final JTable table = this.getTable();
        table.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight());
        table.setShowVerticalLines(false);
        table.setIntercellSpacing((Dimension)JBUI.size((int)0, (int)1));
        this.myTableHeader = table.getTableHeader();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Point point = new Point(e.getPoint());
                int column = table.columnAtPoint(point);
                int row = table.rowAtPoint(point);
                if (row < 0 || column < 0) {
                    return false;
                }
                RowElement item = (RowElement)SectionTableView.this.myData.get(row);
                TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
                JComponent component = (JComponent)table.prepareRenderer(cellRenderer, row, column);
                Rectangle rect = table.getCellRect(row, column, true);
                component.setSize(rect.getSize());
                component.doLayout();
                point.translate(-rect.x, -rect.y);
                if (component.findComponentAt(point) instanceof IconLabel) {
                    item.handleIconLabelClick();
                } else if (clickCount >= 2) {
                    item.handleDoubleClick();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/module/view/ejb/references/SectionTableView$3", "onClick"));
            }
        }.installOn((Component)table);
        MouseInputHandler handler = new MouseInputHandler();
        table.addMouseListener(handler);
        table.addMouseMotionListener(handler);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index = table.getSelectedRow();
                if (index < 0) {
                    return;
                }
                RowElement o = (RowElement)SectionTableView.this.myData.get(index);
                if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                    o.handleLeftRight(e.getKeyCode() == 37);
                }
                if (e.getKeyCode() == 127) {
                    SectionTableView.this.deleteElement();
                } else if (e.getKeyCode() == 155) {
                    if ((e.getModifiers() & 0x200) != 0 || (e.getModifiers() & 8) != 0) {
                        e.consume();
                        DataContext dataContext = DataManager.getInstance().getDataContext((Component)SectionTableView.this.getTable());
                        SectionTableView.this.createAdditionPopup(dataContext).showInBestPositionFor(dataContext);
                    } else {
                        SectionTableView.this.addElement(SectionTableView.this.getSelectedSection());
                    }
                } else if (e.getKeyCode() == 115) {
                    SectionTableView.editElement(SectionTableView.this.getSelectedElement());
                }
            }
        });
        ContainerUtil.addAll(this.myExpandedSections, (Object[])sections);
        this.myDomTableView.initialize();
        this.myTableColumnInfos = this.createColumnInfos();
        this.refreshData();
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(new AnAction(J2EEBundle.message((String)"section.table.view.add", (Object[])new Object[0]), null, DomCollectionControl.ADD_ICON){

            public void update(AnActionEvent e) {
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 0)));
            }

            public void actionPerformed(AnActionEvent e) {
                SectionTableView.this.createAdditionPopup(e.getDataContext()).showUnderneathOf(e.getInputEvent().getComponent());
            }
        });
        toolbarGroup.add(new AnAction(J2EEBundle.message((String)"section.table.view.edit", (Object[])new Object[0]), null, DomCollectionControl.EDIT_ICON){

            public void actionPerformed(AnActionEvent e) {
                SectionTableView.editElement(SectionTableView.this.getSelectedElement());
            }

            public void update(AnActionEvent e) {
                RowElement element = SectionTableView.this.getSelectedElement();
                e.getPresentation().setEnabled(element != null && element.isEditable());
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)));
            }
        });
        toolbarGroup.add(new AnAction(J2EEBundle.message((String)"section.table.view.delete", (Object[])new Object[0]), null, DomCollectionControl.REMOVE_ICON){

            public void actionPerformed(AnActionEvent e) {
                SectionTableView.this.deleteElement();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SectionTableView.this.getSelectedModelElements().size() > 0);
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0)));
            }
        });
        JComponent toolbarComponent = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)toolbarGroup, true).getComponent();
        this.myPanel.add((Component)toolbarComponent, "North");
        this.myPanel.add((Component)((Object)this.myDomTableView), "Center");
        this.myTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBorder(null);
                return this;
            }
        });
        table.setSelectionModel(new MyListSelectionModel(table.getSelectionModel()));
    }

    private ListPopup createAdditionPopup(DataContext dataContext) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (final Section section : this.mySections) {
            if (!section.isVisible()) continue;
            group.add(new AnAction(SectionTableView.getTypeName(section) + "..."){

                public void actionPerformed(AnActionEvent e) {
                    SectionTableView.this.addElement(section);
                }
            });
        }
        return JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
    }

    private void deleteElement() {
        CommonModelManager.getInstance().deleteModelElements(this.getSelectedModelElements(), (JamUserResponse)new DefaultUserResponse(this.myProject));
    }

    private List<CommonModelElement> getSelectedModelElements() {
        int[] ints = this.getTable().getSelectedRows();
        ArrayList<CommonModelElement> elements = new ArrayList<CommonModelElement>();
        for (int anInt : ints) {
            this.myData.get(anInt).addJavaeeModelElements(elements);
        }
        return elements;
    }

    @Nullable
    private RowElement getSelectedElement() {
        int[] selectedRows = this.getTable().getSelectedRows();
        return selectedRows.length != 1 ? null : this.myData.get(selectedRows[0]);
    }

    @Nullable
    private Section<?> getSelectedSection() {
        RowElement element = this.getSelectedElement();
        return element == null ? null : element.getSection();
    }

    private boolean isExpanded(Section section) {
        return this.myExpandedSections.contains(section);
    }

    private void refreshData() {
        this.myData.clear();
        for (Section section : this.mySections) {
            List<? extends DomElement> values;
            if (!section.isVisible() || (values = SectionTableView.getValues(section)).isEmpty()) continue;
            this.myData.add(new SectionRowElement(section));
            if (!this.isExpanded(section)) continue;
            for (DomElement domElement : values) {
                this.myData.add(new DomRowElement(this, (CommonDomModelElement)domElement, section));
            }
        }
        this.myDomTableView.reset(this.myTableColumnInfos, this.myData);
    }

    private static List<? extends DomElement> getValues(Section section) {
        return SectionTableView.getCollectionChildDescription(section).getValues((DomElement)section.getParentElement());
    }

    @NotNull
    private static DomCollectionChildDescription getCollectionChildDescription(@NotNull Section section) {
        DomCollectionChildDescription description;
        if (section == null) {
            SectionTableView.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((description = section.getParentElement().getGenericInfo().getCollectionChildDescription(section.getSubTagName())) != null);
        DomCollectionChildDescription domCollectionChildDescription = description;
        if (domCollectionChildDescription == null) {
            SectionTableView.$$$reportNull$$$0(1);
        }
        return domCollectionChildDescription;
    }

    private ColumnInfo[] createColumnInfos() {
        int maxSize = 0;
        for (Section section : this.mySections) {
            ColumnInfo<T, ?>[] columnInfos = section.createColumnInfos();
            if (columnInfos.length > maxSize) {
                maxSize = columnInfos.length;
            }
            this.myColumnInfos.put(section, columnInfos);
        }
        ColumnInfo[] result = new ColumnInfo[maxSize + 1];
        result[0] = new ColumnInfo<RowElement, Object>(null){

            public TableCellRenderer getRenderer(RowElement item) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object item, boolean isSelected, boolean hasFocus, int row, int column) {
                        return ((RowElement)item).getFirstColumnComponent(isSelected, hasFocus);
                    }
                };
            }

            public Object valueOf(RowElement item) {
                return item;
            }
        };
        for (int j = 0; j < maxSize; ++j) {
            result[j + 1] = SectionTableView.createColumnInfo(j);
        }
        return result;
    }

    private static void editElement(@Nullable RowElement object) {
        if (object != null) {
            object.editElement();
        }
    }

    private <T extends CommonDomModelElement> void addElement(Section<T> section) {
        T added = section.showAddDialog();
        if (added == null) {
            return;
        }
        this.myExpandedSections.add(section);
        this.refreshData();
        int i = this.myData.indexOf(new DomRowElement(this, added, section));
        this.getTable().getSelectionModel().setSelectionInterval(i, i);
    }

    private static ColumnInfo<RowElement, Object> createColumnInfo(final int i) {
        return new ColumnInfo<RowElement, Object>(null){

            public void setValue(RowElement node, Object value) {
                node.setValue(i, value);
            }

            public boolean isCellEditable(RowElement node) {
                return node.isCellEditable(i);
            }

            public TableCellEditor getEditor(RowElement node) {
                return node.getEditor(i);
            }

            public TableCellRenderer getRenderer(RowElement node) {
                return node.getRenderer(i);
            }

            public Object valueOf(RowElement node) {
                return node.getValue(i);
            }
        };
    }

    private ColumnInfo<CommonDomModelElement, Object> getColumnInfo(Section section, int column) {
        ColumnInfo<CommonDomModelElement, Object>[] columnInfos = this.myColumnInfos.get(section);
        return columnInfos.length > column ? columnInfos[column] : MOCK_COLUMN_INFO;
    }

    public void commit() {
    }

    public void reset() {
        this.refreshData();
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private static String getTypeName(@NotNull Section section) {
        if (section == null) {
            SectionTableView.$$$reportNull$$$0(2);
        }
        return TypePresentationService.getService().getTypePresentableName(ReflectionUtil.getRawType((Type)SectionTableView.getCollectionChildDescription(section).getType()));
    }

    private JTable getTable() {
        return this.myDomTableView.getTable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/view/ejb/references/SectionTableView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/view/ejb/references/SectionTableView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionChildDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionChildDescription";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DomRowElement<T extends CommonDomModelElement>
    implements RowElement {
        private final Section<T> mySection;
        private final T myElement;
        final /* synthetic */ SectionTableView this$0;

        public DomRowElement(T rowElement, Section<T> section) {
            this.this$0 = var1_1;
            this.myElement = rowElement;
            this.mySection = section;
        }

        @Override
        public void handleIconLabelClick() {
            this.editElement();
        }

        @Override
        public void handleDoubleClick() {
        }

        @Override
        public void handleLeftRight(boolean isLeft) {
        }

        @Override
        public boolean isEditable() {
            return true;
        }

        @Override
        public boolean isResizeable() {
            return false;
        }

        @Override
        public void addJavaeeModelElements(Collection<CommonModelElement> elements) {
            elements.add((CommonModelElement)this.myElement);
        }

        @Override
        public JComponent decorate(JComponent component, int column, boolean isSelected) {
            JTable table = this.this$0.getTable();
            Border border = BorderFactory.createEmptyBorder(0, 5, 0, column == 0 || column == 2 ? 5 : 0);
            MatteBorder rightGridBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, table.getGridColor());
            if (column == 1 && isSelected) {
                JPanel panel = new JPanel(new BorderLayout());
                component.setBorder(null);
                panel.add(component);
                panel.add((Component)new IconLabel(PlatformIcons.EDIT_IN_SECTION_ICON), "East");
                Color backround = table.getSelectionBackground();
                panel.setBackground(backround);
                border = BorderFactory.createCompoundBorder(border, new EmptyBorder(0, 0, 0, 3));
                component = panel;
            }
            if (column > 0) {
                border = BorderFactory.createCompoundBorder(rightGridBorder, border);
            }
            component.setBorder(border);
            return component;
        }

        @Override
        public JComponent getFirstColumnComponent(boolean isSelected, boolean hasFocus) {
            return (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(this.this$0.getTable(), null, isSelected, hasFocus, 0, 0);
        }

        @Override
        public void editElement() {
            this.mySection.showEditDialog(this.myElement);
            this.this$0.refreshData();
        }

        @Override
        public boolean isCellEditable(int column) {
            return this.this$0.getColumnInfo(this.mySection, column).isCellEditable(this.myElement);
        }

        @Override
        public TableCellRenderer getRenderer(int column) {
            return this.this$0.getColumnInfo(this.mySection, column).getRenderer(this.myElement);
        }

        @Override
        public TableCellEditor getEditor(int column) {
            return this.this$0.getColumnInfo(this.mySection, column).getEditor(this.myElement);
        }

        @Override
        public void setValue(int column, Object value) {
            this.this$0.getColumnInfo(this.mySection, column).setValue(this.myElement, value);
        }

        @Override
        public Object getValue(int column) {
            return this.this$0.getColumnInfo(this.mySection, column).valueOf(this.myElement);
        }

        @Override
        public Section getSection() {
            return this.mySection;
        }

        @Override
        public DomElement getDomElement() {
            return this.myElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomRowElement that = (DomRowElement)o;
            if (!this.myElement.equals(that.myElement)) {
                return false;
            }
            return this.mySection.equals(that.mySection);
        }

        public int hashCode() {
            int result = this.mySection.hashCode();
            result = 31 * result + this.myElement.hashCode();
            return result;
        }
    }

    private class SectionRowElement
    implements RowElement {
        private final Section mySection;

        public SectionRowElement(Section section) {
            this.mySection = section;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SectionRowElement that = (SectionRowElement)o;
            return this.mySection.equals(that.mySection);
        }

        public int hashCode() {
            return this.mySection.hashCode();
        }

        @Override
        public void handleIconLabelClick() {
            if (SectionTableView.this.isExpanded(this.mySection)) {
                SectionTableView.this.myExpandedSections.remove(this.mySection);
            } else {
                SectionTableView.this.myExpandedSections.add(this.mySection);
            }
            SectionTableView.this.refreshData();
        }

        @Override
        public void handleDoubleClick() {
            this.handleIconLabelClick();
        }

        @Override
        public void handleLeftRight(boolean isLeft) {
            if (isLeft && SectionTableView.this.isExpanded(this.mySection)) {
                SectionTableView.this.myExpandedSections.remove(this.mySection);
            } else if (!isLeft && !SectionTableView.this.isExpanded(this.mySection)) {
                SectionTableView.this.myExpandedSections.add(this.mySection);
            }
            SectionTableView.this.refreshData();
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public boolean isResizeable() {
            return SectionTableView.this.isExpanded(this.mySection);
        }

        @Override
        public void addJavaeeModelElements(Collection<CommonModelElement> elements) {
        }

        @Override
        public JComponent decorate(JComponent component, int column, boolean isSelected) {
            JTable table = SectionTableView.this.getTable();
            Border border = BorderFactory.createEmptyBorder(0, 5, 0, column == 0 || column == 2 ? 5 : 0);
            MatteBorder rightGridBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, table.getGridColor());
            Color background = isSelected ? StripeTableCellRenderer.darken((Color)table.getSelectionBackground()) : new Color(SectionTableView.this.myTableHeader.getBackground().getRGB());
            component.setBackground(background);
            border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, background.darker()), border);
            if (SectionTableView.this.isExpanded(this.mySection)) {
                if (column > 1) {
                    border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, background.brighter()), border);
                }
                if (column > 0) {
                    border = BorderFactory.createCompoundBorder(rightGridBorder, border);
                }
            }
            component.setFont(component.getFont().deriveFont(1));
            component.setBorder(border);
            return component;
        }

        @Override
        public JComponent getFirstColumnComponent(boolean isSelected, boolean hasFocus) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(new IconLabel(SectionTableView.this.isExpanded(this.mySection) ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon()));
            return panel;
        }

        @Override
        public void editElement() {
        }

        @Override
        public boolean isCellEditable(int column) {
            return false;
        }

        @Override
        @Nullable
        public TableCellRenderer getRenderer(int column) {
            return null;
        }

        @Override
        public TableCellEditor getEditor(int column) {
            throw new UnsupportedOperationException("Method getEditor is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public void setValue(int column, Object value) {
            throw new UnsupportedOperationException("Method setValue is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public Object getValue(int column) {
            if (column == 0 || SectionTableView.this.isExpanded(this.mySection)) {
                return SectionTableView.this.getColumnInfo(this.mySection, column).getName();
            }
            return null;
        }

        @Override
        public Section getSection() {
            return this.mySection;
        }

        @Override
        @Nullable
        public DomElement getDomElement() {
            return null;
        }
    }

    private static interface RowElement {
        public void handleIconLabelClick();

        public void handleDoubleClick();

        public void handleLeftRight(boolean var1);

        public boolean isEditable();

        public boolean isResizeable();

        public void addJavaeeModelElements(Collection<CommonModelElement> var1);

        public JComponent decorate(JComponent var1, int var2, boolean var3);

        public JComponent getFirstColumnComponent(boolean var1, boolean var2);

        public void editElement();

        public boolean isCellEditable(int var1);

        @Nullable
        public TableCellRenderer getRenderer(int var1);

        @Nullable
        public TableCellEditor getEditor(int var1);

        public void setValue(int var1, Object var2);

        @Nullable
        public Object getValue(int var1);

        @NotNull
        public Section getSection();

        @Nullable
        public DomElement getDomElement();
    }

    private class MyListSelectionModel
    implements ListSelectionModel {
        private final ListSelectionModel myDelegate;

        public MyListSelectionModel(ListSelectionModel delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.setSelectionInterval(index0, index1);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.addSelectionInterval(index0, index1);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.removeSelectionInterval(index0, index1);
        }

        @Override
        public int getMinSelectionIndex() {
            return this.myDelegate.getMinSelectionIndex();
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.myDelegate.getMaxSelectionIndex();
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return this.myDelegate.isSelectedIndex(index);
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.myDelegate.getAnchorSelectionIndex();
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.setAnchorSelectionIndex(index);
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.myDelegate.getLeadSelectionIndex();
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.setLeadSelectionIndex(index);
        }

        @Override
        public void clearSelection() {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.clearSelection();
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.myDelegate.isSelectionEmpty();
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.insertIndexInterval(index, length, before);
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            if (SectionTableView.this.myTableHeader.getResizingColumn() != null) {
                return;
            }
            this.myDelegate.removeIndexInterval(index0, index1);
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
            this.myDelegate.setValueIsAdjusting(valueIsAdjusting);
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.myDelegate.getValueIsAdjusting();
        }

        @Override
        public void setSelectionMode(int selectionMode) {
            this.myDelegate.setSelectionMode(selectionMode);
        }

        @Override
        public int getSelectionMode() {
            return this.myDelegate.getSelectionMode();
        }

        @Override
        public void addListSelectionListener(ListSelectionListener x) {
            this.myDelegate.addListSelectionListener(x);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener x) {
            this.myDelegate.removeListSelectionListener(x);
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = SectionTableView.access$1100();

        private MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private boolean canResize(TableColumn column) {
            return column != null && column.getResizable();
        }

        private TableColumn getResizingColumn(Point p) {
            return this.getResizingColumn(p, SectionTableView.this.getTable().rowAtPoint(p), SectionTableView.this.getTable().columnAtPoint(p));
        }

        private TableColumn getResizingColumn(Point p, int row, int column) {
            int columnIndex;
            if (column == -1 || row == -1) {
                return null;
            }
            RowElement o = (RowElement)SectionTableView.this.myData.get(row);
            if (!o.isResizeable()) {
                return null;
            }
            Rectangle r = SectionTableView.this.getTable().getCellRect(row, column, false);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            if (SectionTableView.this.getTable().getComponentOrientation().isLeftToRight()) {
                columnIndex = p.x < midPoint ? column - 1 : column;
            } else {
                int n = columnIndex = p.x < midPoint ? column : column - 1;
            }
            if (columnIndex < 1) {
                return null;
            }
            return SectionTableView.this.getTable().getColumnModel().getColumn(columnIndex);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTableHeader header = this.getTableHeader();
            header.setDraggedColumn(null);
            header.setResizingColumn(null);
            header.setDraggedDistance(0);
            Point p = e.getPoint();
            TableColumnModel columnModel = SectionTableView.this.getTable().getColumnModel();
            int index = SectionTableView.this.getTable().columnAtPoint(p);
            if (index != -1) {
                TableColumn resizingColumn = this.getResizingColumn(p, SectionTableView.this.getTable().rowAtPoint(p), index);
                if (this.canResize(resizingColumn)) {
                    header.setResizingColumn(resizingColumn);
                    this.mouseXOffset = header.getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
                } else if (header.getReorderingAllowed()) {
                    TableColumn hitColumn = columnModel.getColumn(index);
                    header.setDraggedColumn(hitColumn);
                    this.mouseXOffset = p.x;
                }
            }
        }

        private JTableHeader getTableHeader() {
            return SectionTableView.this.myTableHeader;
        }

        private void swapCursor() {
            Cursor tmp = SectionTableView.this.getTable().getCursor();
            SectionTableView.this.getTable().setCursor(this.otherCursor);
            this.otherCursor = tmp;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.canResize(this.getResizingColumn(e.getPoint())) != (SectionTableView.this.getTable().getCursor() == ourResizeCursor)) {
                this.swapCursor();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int mouseX = e.getX();
            JTableHeader header = this.getTableHeader();
            TableColumn resizingColumn = header.getResizingColumn();
            TableColumn draggedColumn = header.getDraggedColumn();
            this.mouseMoved(e);
            boolean headerLeftToRight = header.getComponentOrientation().isLeftToRight();
            if (resizingColumn != null) {
                JTable table;
                int oldWidth = resizingColumn.getWidth();
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                resizingColumn.setWidth(newWidth);
                JScrollPane scrollPane = JBScrollPane.findScrollPane((Component)header);
                if (scrollPane == null) {
                    return;
                }
                if (!scrollPane.getComponentOrientation().isLeftToRight() && !headerLeftToRight && (table = header.getTable()) != null) {
                    JViewport viewport = scrollPane.getViewport();
                    int viewportWidth = viewport.getWidth();
                    int diff = newWidth - oldWidth;
                    int newHeaderWidth = table.getWidth() + diff;
                    Dimension tableSize = table.getSize();
                    tableSize.width += diff;
                    table.setSize(tableSize);
                    if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                        Point p = viewport.getViewPosition();
                        p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                        viewport.setViewPosition(p);
                        this.mouseXOffset += diff;
                    }
                }
            } else if (draggedColumn != null) {
                TableColumnModel cm = header.getColumnModel();
                int draggedDistance = mouseX - this.mouseXOffset;
                int direction = draggedDistance < 0 ? -1 : 1;
                int columnIndex = this.viewIndexForColumn(draggedColumn);
                int newColumnIndex = columnIndex + (headerLeftToRight ? direction : -direction);
                if (0 <= newColumnIndex && newColumnIndex < cm.getColumnCount()) {
                    int width = cm.getColumn(newColumnIndex).getWidth();
                    if (Math.abs(draggedDistance) > width / 2) {
                        this.mouseXOffset += direction * width;
                        header.setDraggedDistance(draggedDistance - direction * width);
                        cm.moveColumn(columnIndex, newColumnIndex);
                        return;
                    }
                }
                this.setDraggedDistance(draggedDistance, columnIndex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableHeader header = this.getTableHeader();
            this.setDraggedDistance(0, this.viewIndexForColumn(header.getDraggedColumn()));
            header.setResizingColumn(null);
            header.setDraggedColumn(null);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private int viewIndexForColumn(TableColumn aColumn) {
            TableColumnModel cm = SectionTableView.this.getTable().getColumnModel();
            for (int column = 0; column < cm.getColumnCount(); ++column) {
                if (cm.getColumn(column) != aColumn) continue;
                return column;
            }
            return -1;
        }

        private void setDraggedDistance(int draggedDistance, int column) {
            JTableHeader header = this.getTableHeader();
            header.setDraggedDistance(draggedDistance);
            if (column != -1) {
                header.getColumnModel().moveColumn(column, column);
            }
        }
    }

    private class MyDomTableView
    extends AbstractTableView<RowElement> {
        public MyDomTableView(Project project, String helpId) {
            super(project, null, helpId);
        }

        protected TableCellRenderer getTableCellRenderer(int row, int column, final TableCellRenderer superRenderer, Object value) {
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JComponent component = (JComponent)superRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    return ((RowElement)SectionTableView.this.myData.get(row)).decorate(component, column, isSelected);
                }
            };
        }

        protected void wrapValueSetting(@NotNull RowElement element, final Runnable valueSetter) {
            DomElement domElement;
            if (element == null) {
                MyDomTableView.$$$reportNull$$$0(0);
            }
            if ((domElement = element.getDomElement()) != null && domElement.isValid()) {
                new WriteCommandAction(this.getProject(), new PsiFile[]{DomUtil.getFile((DomElement)domElement)}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        valueSetter.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/ejb/references/SectionTableView$MyDomTableView$2", "run"));
                    }
                }.execute();
                this.fireChanged();
            }
        }

        final void initialize() {
            DefaultActionGroup popupGroup = new DefaultActionGroup();
            popupGroup.add(new AnAction(null, null, IconUtil.getAddIcon()){

                public void update(AnActionEvent e) {
                    Section section = SectionTableView.this.getSelectedSection();
                    e.getPresentation().setEnabled(section != null);
                    if (section != null) {
                        e.getPresentation().setText(J2EEBundle.message((String)"section.table.view.add.0", (Object[])new Object[]{SectionTableView.getTypeName(section)}), true);
                    }
                    this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 0)));
                }

                public void actionPerformed(AnActionEvent e) {
                    SectionTableView.this.addElement(SectionTableView.this.getSelectedSection());
                }
            });
            popupGroup.add(new AnAction(null, null, PlatformIcons.EDIT_IN_SECTION_ICON){

                public void update(AnActionEvent e) {
                    RowElement o = SectionTableView.this.getSelectedElement();
                    boolean disabled = o == null || !o.isEditable();
                    e.getPresentation().setEnabled(!disabled);
                    e.getPresentation().setVisible(!disabled);
                    String name = o == null ? null : JamCommonUtil.getDisplayName((Object)o.getDomElement());
                    e.getPresentation().setText(name != null ? J2EEBundle.message((String)"section.table.view.edit.0", (Object[])new Object[]{name}) : J2EEBundle.message((String)"section.table.view.edit", (Object[])new Object[0]));
                    this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)));
                }

                public void actionPerformed(AnActionEvent e) {
                    SectionTableView.editElement(SectionTableView.this.getSelectedElement());
                }
            });
            popupGroup.add(new AnAction(null, null, PlatformIcons.DELETE_ICON){

                public void update(AnActionEvent e) {
                    List elements = SectionTableView.this.getSelectedModelElements();
                    boolean enabled = elements.size() > 0;
                    e.getPresentation().setEnabled(enabled);
                    e.getPresentation().setVisible(enabled);
                    String displayName = elements.size() == 1 ? JamCommonUtil.getDisplayName(elements.get(0)) : JamMessages.message((String)"model.delete.items", (Object[])new Object[0]);
                    e.getPresentation().setText(displayName != null ? J2EEBundle.message((String)"section.table.view.delete.0", (Object[])new Object[]{displayName}) : J2EEBundle.message((String)"section.table.view.delete", (Object[])new Object[0]));
                    this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0)));
                }

                public void actionPerformed(AnActionEvent e) {
                    SectionTableView.this.deleteElement();
                }
            });
            this.installPopup("J2EEAttributesViewPopup", popupGroup);
            this.initializeTable();
        }

        protected void adjustColumnWidths() {
            super.adjustColumnWidths();
            this.setFixedColumnWidth(0);
        }

        private void setFixedColumnWidth(int index) {
            TableColumnModel columnModel = this.getTable().getColumnModel();
            if (columnModel.getColumnCount() <= index) {
                return;
            }
            int width = this.getColumnPreferredWidth(index);
            if (width > 0) {
                TableColumn column = columnModel.getColumn(index);
                column.setMinWidth(width);
                column.setMaxWidth(width);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/module/view/ejb/references/SectionTableView$MyDomTableView", "wrapValueSetting"));
        }
    }

    private static class IconLabel
    extends JLabel {
        public IconLabel(Icon image) {
            super(image);
        }
    }
}

