/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.ejbLevel;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.javaee.EjbUserResponse;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.CmpFieldUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.xml.DescriptionOwner;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ui.DescriptionBigStringComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCmpFieldDialog
extends DialogWrapper {
    private JTextField myName;
    private DescriptionBigStringComponent myDescription;
    private ComboboxWithBrowseButton myType;
    private JCheckBox myGetterLocal;
    private JCheckBox myGetterRemote;
    private JCheckBox mySetterLocal;
    private JCheckBox mySetterRemote;
    private JPanel myPanel;
    private final EntityBean myEjb;
    private final Module myModule;
    private JCheckBox myPrimaryKey;
    private JLabel myTypeLabel;
    private JLabel myDescriptionLabel;
    @NonNls
    protected static final String FIELD_DEFAULT_NAME = "myField";
    @NonNls
    private static final String DEFAULT_NAME = "myField";
    private final Collection<String> myExiststingNames;

    public CreateCmpFieldDialog(Module module, EntityBean ejb, String title) {
        super(module.getProject(), true);
        this.$$$setupUI$$$();
        this.myExiststingNames = new HashSet();
        this.myModule = module;
        this.myEjb = ejb;
        this.fillExistingNames(ejb, null);
        this.setupControls();
        this.init();
        this.setTitle(title);
    }

    public CreateCmpFieldDialog(com.intellij.javaee.model.xml.ejb.CmpField cmpField, String title) {
        super(cmpField.getPsiManager().getProject(), true);
        this.$$$setupUI$$$();
        this.myExiststingNames = new HashSet();
        this.myModule = cmpField.getModule();
        this.myEjb = (EntityBean)cmpField.getParent();
        this.fillExistingNames(this.myEjb, cmpField);
        this.setupControls();
        this.init();
        this.setTitle(title);
        this.myName.setText((String)cmpField.getFieldName().getValue());
        PsiType type = EjbUtil.findType((CmpField)cmpField);
        this.myType.getComboBox().getEditor().setItem(type == null ? "" : type.getCanonicalText());
        this.myDescription.setText(JavaeeUtil.getDescription((DescriptionOwner)cmpField));
        this.myPrimaryKey.setSelected(EjbUtil.isPK((CmpField)cmpField));
        this.mySetterLocal.setSelected(CmpFieldUtil.hasLocalSetter(cmpField));
        this.myGetterLocal.setSelected(CmpFieldUtil.hasLocalGetter(cmpField));
        this.mySetterRemote.setSelected(CmpFieldUtil.hasRemoteSetter(cmpField));
        this.myGetterRemote.setSelected(CmpFieldUtil.hasRemoteGetter(cmpField));
    }

    private String createUniqueFieldName() {
        if (!this.isCmpFieldExists("myField")) {
            return "myField";
        }
        int i = 1;
        String nextName;
        while (this.isCmpFieldExists(nextName = "myField" + i)) {
            ++i;
        }
        return nextName;
    }

    private void fillExistingNames(EntityBean ejb, com.intellij.javaee.model.xml.ejb.CmpField field) {
        for (com.intellij.javaee.model.xml.ejb.CmpField cmpField : ejb.getCmpFields()) {
            String name;
            if (cmpField.equals(field) || (name = (String)cmpField.getFieldName().getValue()) == null) continue;
            this.myExiststingNames.add(name);
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            CreateCmpFieldDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("j2ee.cmp.field");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void setupControls() {
        this.myName.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (offs == 0 && str != null && str.length() != 0) {
                    str = Character.toLowerCase(str.charAt(0)) + str.substring(1);
                }
                super.insertString(offs, str, a);
            }
        });
        this.myName.setText(this.createUniqueFieldName());
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateCmpFieldDialog.this.updateCmpName();
            }
        });
        LinkedHashSet<String> predefinedTypes = new LinkedHashSet<String>(Arrays.asList(CmpFieldUtil.PREDEFINED_TYPES));
        String type = CmpFieldUtil.PREDEFINED_TYPES[8];
        predefinedTypes.add(type);
        final JComboBox comboBox = (JComboBox)this.myType.getChildComponent();
        for (String predefinedType : predefinedTypes) {
            comboBox.addItem(predefinedType);
        }
        comboBox.setEditable(true);
        this.myType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)CreateCmpFieldDialog.this.getProject()).createProjectScopeChooser(J2EEBundle.message((String)"dialog.title.choose.cmp.field.class", (Object[])new Object[0]));
                PsiClass cmpClass = CreateCmpFieldDialog.this.getCmpClass();
                if (cmpClass != null) {
                    chooser.selectDirectory(cmpClass.getContainingFile().getContainingDirectory());
                }
                chooser.showDialog();
                PsiClass aClass = chooser.getSelected();
                if (aClass != null) {
                    comboBox.setSelectedItem(aClass.getQualifiedName());
                }
            }
        });
        comboBox.getEditor().setItem(type);
        comboBox.setSelectedItem(type);
        this.myDescriptionLabel.setLabelFor(this.myDescription.getTextField());
        this.myTypeLabel.setLabelFor(comboBox);
        boolean hasLocal = this.myEjb.getLocal().getValue() != null;
        boolean hasRemote = this.myEjb.getRemote().getValue() != null;
        this.myGetterLocal.setSelected(hasLocal);
        this.myGetterLocal.setEnabled(hasLocal);
        this.myGetterRemote.setSelected(hasRemote);
        this.myGetterRemote.setEnabled(hasRemote);
        this.mySetterLocal.setSelected(hasLocal);
        this.mySetterLocal.setEnabled(hasLocal);
        this.mySetterRemote.setSelected(hasRemote);
        this.mySetterRemote.setEnabled(hasRemote);
    }

    private Project getProject() {
        return this.myModule.getProject();
    }

    private void updateCmpName() {
        String text = this.myName.getText();
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(text));
    }

    protected void doOKAction() {
        String error = this.isCmpFieldExists(this.getName()) ? J2EEBundle.message((String)"message.text.cmp.field.exists", (Object[])new Object[]{this.getName()}) : (!PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(this.getName()) ? J2EEBundle.message((String)"message.text.cmp.field.name.not.valid", (Object[])new Object[]{this.getName()}) : (!Character.isLowerCase(this.getName().charAt(0)) ? J2EEBundle.message((String)"message.text.cmp.field.name.should.begin.with.a.lower.case.letter", (Object[])new Object[0]) : (this.getType(this.getTypeName()) == null ? J2EEBundle.message((String)"message.text.type.not.found", (Object[])new Object[]{this.getTypeName()}) : null)));
        if (error != null) {
            Messages.showMessageDialog((Project)this.getProject(), (String)error, (String)J2EEBundle.message((String)"message.title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    private String getName() {
        return this.myName.getText();
    }

    private String getDescription() {
        return this.myDescription.getText();
    }

    @Nullable
    private PsiType getType(String text) {
        try {
            PsiType componentType;
            PsiType type = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(text, null);
            if (type instanceof PsiPrimitiveType) {
                return type;
            }
            if (type instanceof PsiArrayType && (componentType = ((PsiArrayType)type).getComponentType()) != null && this.getType(componentType.getCanonicalText()) != null) {
                return type;
            }
            if (type instanceof PsiClassType && ((PsiClassType)type).resolve() != null) {
                return type;
            }
            return null;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private PsiClass getCmpClass() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.getTypeName(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    private String getTypeName() {
        return (String)((JComboBox)this.myType.getChildComponent()).getEditor().getItem();
    }

    private boolean isCmpFieldExists(String name) {
        return this.myExiststingNames.contains(name);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.j2ee.ejb.actions.CreateCmpFieldDialog";
    }

    public com.intellij.javaee.model.xml.ejb.CmpField createCmpField(EjbUserResponse response) {
        return CmpFieldUtil.createCmpField(this.myEjb, this.getName(), this.getDescription(), this.getTypeName(), this.myPrimaryKey.isSelected(), this.myGetterLocal.isSelected(), this.mySetterLocal.isSelected(), this.myGetterRemote.isSelected(), this.mySetterRemote.isSelected(), response);
    }

    public void apply(EjbUserResponse response, com.intellij.javaee.model.xml.ejb.CmpField cmpField) {
        CmpFieldUtil.updateCmpField(this.myEjb, cmpField, this.getName(), this.getDescription(), this.getTypeName(), this.myGetterLocal.isSelected(), this.myGetterRemote.isSelected(), this.mySetterLocal.isSelected(), this.mySetterRemote.isSelected(), this.myPrimaryKey.isSelected(), response);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/ejbLevel/CreateCmpFieldDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JLabel jLabel;
        DescriptionBigStringComponent descriptionBigStringComponent;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.cmp.field.name"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescriptionLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.cmp.field.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDescription = descriptionBigStringComponent = new DescriptionBigStringComponent();
        jPanel2.add((Component)descriptionBigStringComponent, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myTypeLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.cmp.field.type"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myType = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myPrimaryKey = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.cmp.field.primary.key"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.cmp.field.properties.generate.getter.in"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.cmp.field.properties.generate.setter.in"));
        jPanel3.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGetterLocal = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.cmp.field.properties.generate.getter.in.local.interface"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySetterLocal = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.cmp.field.properties.generate.setter.in.local.interface"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGetterRemote = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.cmp.field.properties.generate.getter.in.remote.interface"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySetterRemote = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.cmp.field.properties.generate.setter.in.remote.interface"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

