/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.appServerIntegrations.AppServerDescriptorsMetaDataProvider;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.ui.DeploymentDescriptorsOwnerBase;
import com.intellij.javaee.ui.EditingDeploymentDescriptorSetComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class J2EEGeneralModuleViewlets
implements Disposable {
    private final JavaeeFacet myFacet;
    private final FacetEditorContext myContext;
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private final JComponent myDDPanel = new JPanel(new BorderLayout());
    private final EditingDeploymentDescriptorSetComponent myDeploymentDescriptorSetComponent;
    protected final MyDeploymentDescriptorsOwner myDescriptorsOwner;

    public J2EEGeneralModuleViewlets(JavaeeFacet facet, FacetEditorContext context) {
        this.myFacet = facet;
        this.myContext = context;
        File defaultParent = J2EEGeneralModuleViewlets.getDefaultDDParent(this.myFacet);
        AppServerDescriptorsMetaDataProvider metaDataProvider = ((JavaeeFacetType)this.myFacet.getType()).getDescriptorsMetaDataProvider();
        boolean isNew = context.isNewFacet();
        this.myDescriptorsOwner = new MyDeploymentDescriptorsOwner(this.myFacet, context);
        this.myDeploymentDescriptorSetComponent = new EditingDeploymentDescriptorSetComponent(this.myDescriptorsOwner, this.myFacet.getDescriptorsContainer().getConfiguration(), metaDataProvider, defaultParent, isNew);
    }

    private JComponent createNorthPanel() {
        return this.myDDPanel;
    }

    private JComponent createDeploymentDescriptorsView() {
        return this.myDeploymentDescriptorSetComponent.createComponent();
    }

    private static File getDefaultDDParent(JavaeeFacet facet) {
        for (ConfigFile deploymentDescriptor : facet.getDescriptorsContainer().getConfigFiles()) {
            String path;
            File descriptorFile;
            File parentFile;
            String url = deploymentDescriptor.getUrl();
            if (url == null || (parentFile = (descriptorFile = new File(path = VfsUtil.urlToPath((String)url))).getParentFile()) == null) continue;
            if (parentFile.getName().equalsIgnoreCase(deploymentDescriptor.getMetaData().getDirectoryPath())) {
                parentFile = parentFile.getParentFile();
            }
            return parentFile.getAbsoluteFile();
        }
        return new File(facet.getModule().getModuleFilePath()).getAbsoluteFile().getParentFile();
    }

    protected JavaeeFacet getFacet() {
        return this.myFacet;
    }

    public JComponent createComponent() {
        this.setupViewlets();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add("Center", this.myPanel);
        return contentPanel;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    public void saveData() {
        this.myDeploymentDescriptorSetComponent.applyChanges();
        CommandProcessor.getInstance().runUndoTransparentAction(() -> this.myDescriptorsOwner.createAndDeleteFiles(this.myFacet.getModule().getProject()));
    }

    public boolean isEditing() {
        return false;
    }

    private void setupViewlets() {
        this.myPanel.add((Component)this.createNorthPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        JComponent sourcePanel = this.createSouthPanel();
        if (sourcePanel != null) {
            this.myPanel.add((Component)sourcePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.myDDPanel.add((Component)this.createDeploymentDescriptorsView(), "Center");
    }

    public void dispose() {
    }

    public boolean isModified() {
        return this.myDeploymentDescriptorSetComponent.isModified();
    }

    protected FacetEditorContext getContext() {
        return this.myContext;
    }

    protected static class MyDeploymentDescriptorsOwner
    extends DeploymentDescriptorsOwnerBase {
        private final JavaeeFacet myFacet;

        public MyDeploymentDescriptorsOwner(JavaeeFacet facet, FacetEditorContext context) {
            super(context);
            this.myFacet = facet;
        }

        @Override
        @NonNls
        protected String getBaseDirectoryName(ConfigFileMetaData metaData) {
            return metaData == DeploymentDescriptorsConstants.WEB_XML_META_DATA ? "/web" : "";
        }

        @Override
        public boolean canBeParentForDescriptors(VirtualFile dir) {
            Module module = this.myFacet.getModule();
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile excludeRoot : rootManager.getExcludeRoots()) {
                if (!VfsUtil.isAncestor((VirtualFile)excludeRoot, (VirtualFile)dir, (boolean)false)) continue;
                return false;
            }
            return true;
        }
    }
}

