/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.AppServerSpecificValidator;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.make.AppServerSpecificValidatorsManager;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class AppServerSpecificValidatorsConfigurable
implements UnnamedConfigurable {
    private final Map<ApplicationServer, String> myServer2ValidatorName;
    private List<ApplicationServer> myValidatorOwners = new ArrayList<ApplicationServer>();
    private JList<ApplicationServer> myServersList;
    private DefaultListModel<ApplicationServer> myListModel = new DefaultListModel();
    private final AppServerSpecificValidatorsManager myValidatorsManager;

    public AppServerSpecificValidatorsConfigurable(JavaeeFacet facet, ArtifactType artifactType, Project project, AppServerSpecificValidatorsManager validatorsManager) {
        this.myValidatorsManager = validatorsManager;
        this.myServer2ValidatorName = new HashMap<ApplicationServer, String>();
        List allServers = ApplicationServersManager.getInstance().getApplicationServers();
        for (ApplicationServer server : allServers) {
            AppServerSpecificValidator validator;
            AppServerIntegration integration = server.getSourceIntegration();
            if (integration == null || (validator = facet != null ? integration.getAppServerSpecificValidator(facet, server) : integration.getAppServerSpecificValidator(server, artifactType, project)) == null) continue;
            this.myServer2ValidatorName.put(server, validator.getDisplayName());
        }
    }

    public JComponent createComponent() {
        this.myServersList = new JBList(this.myListModel);
        this.myServersList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ApplicationServer server = (ApplicationServer)value;
                if (server != null) {
                    String validatorName = (String)AppServerSpecificValidatorsConfigurable.this.myServer2ValidatorName.get(server);
                    value = validatorName != null ? J2EEBundle.message((String)"appserver.validator.presentable.text", (Object[])new Object[]{validatorName, server.getName()}) : server.getName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        JPanel panel = ToolbarDecorator.createDecorator(this.myServersList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List serversList = AppServerSpecificValidatorsConfigurable.this.getNotUsedServers();
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ApplicationServer>(null, serversList){

                    public PopupStep onChosen(ApplicationServer selectedValue, boolean finalChoice) {
                        return this.doFinalStep(() -> {
                            AppServerSpecificValidatorsConfigurable.this.myValidatorOwners.add(selectedValue);
                            AppServerSpecificValidatorsConfigurable.this.refreshList();
                            AppServerSpecificValidatorsConfigurable.this.myServersList.setSelectedValue(selectedValue, true);
                        });
                    }
                });
                listPopup.show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object[] selectedValues = AppServerSpecificValidatorsConfigurable.this.myServersList.getSelectedValues();
                int index = AppServerSpecificValidatorsConfigurable.this.myServersList.getSelectedIndex();
                for (Object selectedValue : selectedValues) {
                    ApplicationServer server = (ApplicationServer)selectedValue;
                    AppServerSpecificValidatorsConfigurable.this.myValidatorOwners.remove(server);
                }
                AppServerSpecificValidatorsConfigurable.this.refreshList();
                index = Math.max(index, 0);
                index = Math.min(index, AppServerSpecificValidatorsConfigurable.this.myServersList.getModel().getSize() - 1);
                if (index >= 0) {
                    AppServerSpecificValidatorsConfigurable.this.myServersList.setSelectedIndex(index);
                }
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                List servers = AppServerSpecificValidatorsConfigurable.this.getNotUsedServers();
                return !servers.isEmpty();
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return AppServerSpecificValidatorsConfigurable.this.myServersList.getSelectedValue() != null;
            }
        }).disableUpDownActions().createPanel();
        UIUtil.addBorder((JComponent)panel, (Border)IdeBorderFactory.createTitledBorder((String)J2EEBundle.message((String)"title.appserver.specific.validators", (Object[])new Object[0]), (boolean)false));
        return panel;
    }

    private List<ApplicationServer> getNotUsedServers() {
        ArrayList<ApplicationServer> serversList = new ArrayList<ApplicationServer>(this.myServer2ValidatorName.keySet());
        serversList.removeAll(this.myValidatorOwners);
        return serversList;
    }

    public boolean isModified() {
        return !this.myValidatorOwners.equals(Arrays.asList(this.myValidatorsManager.getValidatorOwners()));
    }

    public void apply() {
        this.myValidatorsManager.setValidatorsOwners(this.myValidatorOwners.toArray(new ApplicationServer[this.myValidatorOwners.size()]));
    }

    public void reset() {
        ApplicationServer[] servers = this.myValidatorsManager.getValidatorOwners();
        this.myValidatorOwners = new ArrayList<ApplicationServer>(Arrays.asList(servers));
        this.refreshList();
    }

    private void refreshList() {
        this.myListModel.removeAllElements();
        for (ApplicationServer server : this.myValidatorOwners) {
            this.myListModel.addElement(server);
        }
    }

    public void disposeUIResources() {
    }
}

