/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JavaeeUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        boolean addFix;
        Module module;
        if (ref == null) {
            JavaeeUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            JavaeeUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)ref)) == null) {
            return;
        }
        String text = ref.getCanonicalText();
        if (JavaeeUnresolvedReferenceQuickFixProvider.isJavaeeQName(text)) {
            addFix = true;
        } else if (text.indexOf(46) < 0) {
            PsiFile containingFile = ref.getContainingFile();
            PsiImportList importList = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getImportList() : null;
            addFix = importList != null && null != ContainerUtil.find((Object[])importList.getImportStatements(), statement -> {
                String qname = statement.getQualifiedName();
                if (qname == null || !JavaeeUnresolvedReferenceQuickFixProvider.isJavaeeQName(qname)) {
                    return false;
                }
                return qname.endsWith("" + text) || statement.resolve() == null;
            });
        } else {
            addFix = false;
        }
        if (addFix) {
            registrar.register((IntentionAction)JavaeeLibrariesUtil.createAddJavaeeLibraryQuickFix(module, "Java EE libraries"));
        }
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            JavaeeUnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(2);
        }
        return PsiJavaCodeReferenceElement.class;
    }

    private static boolean isJavaeeQName(String text) {
        if (text.startsWith("javax.")) {
            Object[] packageList = new String[]{"activation", "annotation", "ejb", "el", "enterprise", "interceptor", "jms", "jws", "mail", "persistence", "resource", "security", "servlet", "transaction", "xml"};
            return null != ContainerUtil.find((Object[])packageList, pkg -> {
                String packageName = "javax." + pkg;
                return text.startsWith(packageName) && (text.length() == packageName.length() || text.charAt(packageName.length()) == '.');
            });
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/JavaeeUnresolvedReferenceQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/JavaeeUnresolvedReferenceQuickFixProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

