/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.model.annotations.ejb.EnterpriseBeanImpl;
import com.intellij.javaee.model.common.ejb.NonEntityBean;
import com.intellij.javaee.model.enums.TransactionType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.xml.GenericValue;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class NonEntityBeanImpl
extends EnterpriseBeanImpl
implements NonEntityBean {
    private List<AnnotationGenericValue<PsiMethod>> myTimeoutMethods;

    protected NonEntityBeanImpl(PsiClass psiClass) {
        super(psiClass);
    }

    public GenericValue<TransactionType> getTransactionManagementType() {
        return AnnotationModelUtil.getEnumValue(this.findAnnotation("javax.ejb.TransactionManagement"), "value", TransactionType.class);
    }

    protected boolean isStandardInterface(String qName) {
        return qName == null || qName.startsWith("javax.ejb.") || qName.equals("java.io.Serializable") || qName.equals("java.io.Externalizable");
    }

    @Nullable
    protected PsiClass getDefaultBusinessInterface(PsiClass psiClass) {
        PsiClass psiInterface = null;
        for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass)) {
            for (PsiClass aClass : curClass.getInterfaces()) {
                String qName = aClass.getQualifiedName();
                if (this.isStandardInterface(qName)) continue;
                if (psiInterface != null) {
                    if (aClass.isInheritor(psiInterface, true)) {
                        psiInterface = aClass;
                        continue;
                    }
                    if (psiInterface.isInheritor(aClass, true)) continue;
                    return null;
                }
                psiInterface = aClass;
            }
        }
        return psiInterface;
    }

    public GenericValue<PsiMethod> getTimeoutMethodValue() {
        for (EjbMethodImpl method : this.getEjbMethods()) {
            Boolean value = (Boolean)method.isTimeoutMethod().getValue();
            if (value == null || !value.booleanValue()) continue;
            return AnnotationGenericValue.getInstance(method.getPsiMethod(), null, null);
        }
        return AnnotationGenericValue.nullInstance();
    }
}

