/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.jam.model.common.CommonDomModelElement;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.module.view.common.J2EEModuleElementsEditor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeFacetUtilImpl
extends JavaeeFacetUtil {
    private static final Key<JavaeeFacet> MOCK_ELEMENT_FACET_KEY = Key.create((String)"MockElementJavaeeFacet");
    private static final Collection<FacetTypeId<? extends JavaeeFacet>> JAVAEE_FACET_TYPES;

    public JavaeeFacet[] getAllJavaeeFacets(Module ... modules) {
        ArrayList facets = new ArrayList();
        for (Module module : modules) {
            facets.addAll(WebFacet.getInstances((Module)module));
            facets.addAll(EjbFacet.getInstances((Module)module));
            facets.addAll(JavaeeApplicationFacet.getInstances((Module)module));
        }
        return facets.toArray(new JavaeeFacet[facets.size()]);
    }

    public <F extends JavaeeFacet> Collection<F> getJavaeeFacets(FacetTypeId<F> type, Module ... modules) {
        ArrayList facets = new ArrayList();
        for (Module module : modules) {
            facets.addAll(FacetManager.getInstance((Module)module).getFacetsByType(type));
        }
        return facets;
    }

    public <F extends JavaeeFacet> Collection<F> getJavaeeFacets(FacetTypeId<F> type, Project project) {
        return project.isDisposed() ? Collections.emptySet() : this.getJavaeeFacets(type, ModuleManager.getInstance((Project)project).getModules());
    }

    public JavaeeFacet[] getAllJavaeeFacets(Project project) {
        return this.getAllJavaeeFacets(ModuleManager.getInstance((Project)project).getModules());
    }

    public Collection<FacetTypeId<? extends JavaeeFacet>> getAllJavaeeFacetTypes() {
        return JAVAEE_FACET_TYPES;
    }

    public Collection<FacetTypeId<? extends JavaeeFacet>> getSingletonCollection(FacetTypeId<? extends JavaeeFacet> facetTypeId) {
        HashSet<FacetTypeId<? extends JavaeeFacet>> set = new HashSet<FacetTypeId<? extends JavaeeFacet>>();
        set.add(facetTypeId);
        return set;
    }

    public <F extends JavaeeFacet> F getJavaeeFacet(VirtualFile file, FacetTypeId<F> type, Project project) {
        return (F)((JavaeeFacet)FacetFinder.getInstance((Project)project).findFacet(file, type));
    }

    @Nullable
    public JavaeeFacet getJavaeeFacet(VirtualFile file, Project project) {
        for (FacetTypeId<? extends JavaeeFacet> facetType : JAVAEE_FACET_TYPES) {
            JavaeeFacet facet = this.getJavaeeFacet(file, facetType, project);
            if (facet == null) continue;
            return facet;
        }
        return null;
    }

    public void setFacetForMockElement(DomElement element, JavaeeFacet facet) {
        DomUtil.getFile((DomElement)element).putUserData(MOCK_ELEMENT_FACET_KEY, (Object)facet);
    }

    @Nullable
    public <F extends JavaeeFacet> F getJavaeeFacet(@NotNull JavaeeModelElement element, FacetTypeId<F> type) {
        VirtualFile virtualFile;
        F facet;
        PsiFile file;
        if (element == null) {
            JavaeeFacetUtilImpl.$$$reportNull$$$0(0);
        }
        if ((file = element.getContainingFile()) != null && (facet = this.getJavaeeFacet(virtualFile = file.getVirtualFile(), type, element.getPsiManager().getProject())) != null) {
            return facet;
        }
        if (element instanceof DomElement) {
            return JavaeeFacetUtilImpl.getFacetFromMockElement(type, DomUtil.getFile((DomElement)((DomElement)element)));
        }
        return null;
    }

    @Nullable
    public <F extends JavaeeFacet> F getJavaeeFacet(@Nullable PsiElement element, FacetTypeId<F> type) {
        DomFileElement domFileElement;
        if (element == null || !element.isValid()) {
            return null;
        }
        Project project = element.getProject();
        if (project.isDefault()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return virtualFile == null ? null : (F)this.getJavaeeFacet(virtualFile, type, project);
        }
        VirtualFile file = (psiFile = psiFile.getOriginalFile()).getVirtualFile();
        F facet = this.getJavaeeFacet(file, type, project);
        if (facet != null) {
            return facet;
        }
        if (psiFile instanceof XmlFile && (domFileElement = DomManager.getDomManager((Project)project).getFileElement((XmlFile)psiFile, CommonDomModelElement.class)) != null) {
            return JavaeeFacetUtilImpl.getFacetFromMockElement(type, domFileElement.getFile());
        }
        return null;
    }

    @Nullable
    public <F extends JavaeeFacet> F getJavaeeFacet(ConvertContext convertContext, FacetTypeId<F> typeId) {
        F javaeeFacet = this.getJavaeeFacet((PsiElement)convertContext.getFile(), typeId);
        if (javaeeFacet != null) {
            return javaeeFacet;
        }
        DomElement element = convertContext.getInvocationElement();
        return JavaeeFacetUtilImpl.getFacetFromMockElement(typeId, DomUtil.getFile((DomElement)element));
    }

    @Nullable
    private static <F extends JavaeeFacet> F getFacetFromMockElement(FacetTypeId<F> typeId, XmlFile file) {
        JavaeeFacet facet = (JavaeeFacet)file.getUserData(MOCK_ELEMENT_FACET_KEY);
        if (facet != null && facet.getTypeId().equals(typeId)) {
            return (F)facet;
        }
        return null;
    }

    @Nullable
    public JavaeeFacet getJavaeeFacet(ConvertContext convertContext) {
        for (FacetTypeId<? extends JavaeeFacet> type : JAVAEE_FACET_TYPES) {
            JavaeeFacet javaeeFacet = this.getJavaeeFacet(convertContext, type);
            if (javaeeFacet == null) continue;
            return javaeeFacet;
        }
        return null;
    }

    public boolean showFacetDescriptorsSettingsEditor(JavaeeFacet facet) {
        return ModulesConfigurator.showFacetSettingsDialog((Facet)facet, (String)J2EEModuleElementsEditor.getEditorName(facet.getType()));
    }

    static {
        LinkedHashSet<FacetTypeId> set = new LinkedHashSet<FacetTypeId>();
        set.add(WebFacet.ID);
        set.add(EjbFacet.ID);
        set.add(JavaeeApplicationFacet.ID);
        JAVAEE_FACET_TYPES = Collections.unmodifiableSet(set);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/facet/JavaeeFacetUtilImpl", "getJavaeeFacet"));
    }
}

