/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.JavaeeIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbFinderRecursivePanel
extends FinderRecursivePanel<EnterpriseBean> {
    private final Module myModule;

    public EjbFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions, @NotNull String groupId) {
        if (parent == null) {
            EjbFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            EjbFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        super(parent.getProject(), parent, groupId);
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(EnterpriseBean bean) {
        PsiElement element = EjbFinderRecursivePanel.getPsiElement(bean);
        if (element != null) {
            DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
            DocumentationComponent component = new DocumentationComponent(manager);
            manager.fetchDocInfo(element, component);
            Disposer.register((Disposable)this, (Disposable)component);
            return component;
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        EnterpriseBean jamElement = (EnterpriseBean)this.getSelectedValue();
        PsiElement element = EjbFinderRecursivePanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(@Nullable EnterpriseBean jamElement) {
        return jamElement == null ? null : jamElement.getIdentifyingPsiElement();
    }

    @NotNull
    protected String getItemText(EnterpriseBean bean) {
        PsiClass aClass;
        StringBuilder sb = new StringBuilder();
        String value = bean.getEjbName().getStringValue();
        if (value != null) {
            sb.append(value);
            sb.append(" ");
        }
        if ((aClass = (PsiClass)bean.getEjbClass().getValue()) != null) {
            PsiModifierList modifierList;
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName != null) {
                sb.append(qualifiedName);
            }
            if ((modifierList = aClass.getModifierList()) != null) {
                PsiAnnotation[] annotations;
                for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                    String fqName = annotation.getQualifiedName();
                    if (fqName == null) continue;
                    sb.append(" @").append(StringUtil.getShortName((String)fqName));
                }
            }
        }
        String string = sb.toString();
        if (string == null) {
            EjbFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        return super.createDefaultRightComponent();
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, EnterpriseBean value, int index, boolean selected, boolean hasFocus) {
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        String beanName = value.getEjbName().getStringValue();
        PsiClass beanClass = (PsiClass)value.getEjbClass().getValue();
        if (beanClass == null) {
            comp.append("<unknown>", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return;
        }
        String qualifiedName = beanClass.getQualifiedName();
        String className = StringUtil.getShortName((String)qualifiedName);
        if (!StringUtil.isEmptyOrSpaces((String)beanName)) {
            comp.append("\"" + beanName + "\"");
            comp.append(" (" + className + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            PsiModifierList modifierList;
            PsiElement element = value.getIdentifyingPsiElement();
            comp.append(className);
            comp.append(" (" + StringUtil.getPackageName((String)qualifiedName) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            if (element instanceof PsiClass && (modifierList = ((PsiClass)element).getModifierList()) != null) {
                PsiAnnotation[] annotations;
                for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                    String fqName = annotation.getQualifiedName();
                    if (fqName == null) continue;
                    comp.append(" @" + StringUtil.getShortName((String)fqName), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
            }
        }
    }

    @Nullable
    protected Icon getItemIcon(EnterpriseBean ejb) {
        if (ejb instanceof EntityBean) {
            return JavaeeIcons.ENTITY_BEAN;
        }
        if (ejb instanceof SessionBean) {
            return JavaeeIcons.SESSION_BEAN;
        }
        if (ejb instanceof MessageDrivenBean) {
            return JavaeeIcons.MESSAGE_BEAN;
        }
        return JavaeeIcons.EJB_ICON;
    }

    @NotNull
    protected List<EnterpriseBean> getListItems() {
        ArrayList<EnterpriseBean> beans = new ArrayList<EnterpriseBean>();
        if (this.myModule != null) {
            for (EjbFacet facet : EjbFacet.getInstances((Module)this.myModule)) {
                beans.addAll(EjbCommonModelUtil.getAllEjbs((Project)this.getProject(), (Module)this.myModule, (EjbFacet)facet));
            }
        } else {
            beans.addAll(EjbCommonModelUtil.getAllEjbs((Project)this.getProject()));
        }
        Collections.sort(beans, (o1, o2) -> {
            String value1 = (String)o1.getEjbName().getValue();
            String value2 = (String)o2.getEjbName().getValue();
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value2 == null) {
                return 1;
            }
            return value1.compareTo(value2);
        });
        ArrayList<EnterpriseBean> arrayList = beans;
        if (arrayList == null) {
            EjbFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected boolean hasChildren(EnterpriseBean bean) {
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/view/EjbFinderRecursivePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/view/EjbFinderRecursivePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

