/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbProhibitedPackageUsageInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.prohibited.package.usage", new Object[0]);
        if (string == null) {
            EjbProhibitedPackageUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbProhibitedPackageUsageInspection" == null) {
            EjbProhibitedPackageUsageInspection.$$$reportNull$$$0(1);
        }
        return "EjbProhibitedPackageUsageInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            EjbProhibitedPackageUsageInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbProhibitedPackageUsageInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiClass psiClass = PsiUtil.getTopLevelClass((PsiElement)reference);
                if (psiClass != null && EjbProhibitedPackageUsageInspection.this.acceptClass(psiClass)) {
                    EjbProhibitedPackageUsageInspection.checkReferenceElement(holder, reference);
                }
            }
        };
    }

    private static void checkReferenceElement(ProblemsHolder holder, PsiJavaCodeReferenceElement element) {
        String qualifiedName;
        PsiElement resolved;
        if (element.getText() != null && (resolved = element.resolve()) instanceof PsiClass && (qualifiedName = ((PsiClass)resolved).getQualifiedName()) != null && Pattern.matches("^(java\\.io\\.File|java\\.awt|javax\\.swing|java\\.lang\\.reflect|java\\.security\\.Policy|java\\.security\\.Security|java\\.security\\.Provider|java\\.security\\.Signer|java\\.security\\.Identity|java\\.net\\.ServerSocket|java\\.lang\\.ClassLoader|java\\.lang\\.SecurityManager|java\\.lang\\.Thread).*$", qualifiedName)) {
            holder.registerProblem((PsiElement)element, EjbHighlightingMessages.message("prohibited.package.usage", qualifiedName), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

