/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.generation.actions.GenerateInterceptorMethods;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbInterceptorInspection;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.InterceptorMethodType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbInterceptorWarningsInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.interceptor.warnings", new Object[0]);
        if (string == null) {
            EjbInterceptorWarningsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbInterceptorWarningsInspection" == null) {
            EjbInterceptorWarningsInspection.$$$reportNull$$$0(1);
        }
        return "EjbInterceptorWarningsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            EjbInterceptorWarningsInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EnumSet<EjbClassRoleEnum> roleTypes = EjbInterceptorWarningsInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(psiClass));
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbInterceptorWarningsInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbInterceptorWarningsInspection.checkInterceptorMethods(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }
        };
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        boolean ejbClass = false;
        boolean standardOnly = false;
        for (EjbClassRole role : classRoles) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                standardOnly = false;
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            if (!standardOnly) {
                standardOnly = EjbUtil.implementsStandardEjbInterface(role.getEnterpriseBean());
            }
            ejbClass = true;
        }
        EjbInterceptorWarningsInspection.checkInterceptorMethods(holder, aClass, EjbInterceptorInspection.buildInterceptorMethodsMap(classRoles, null), !ejbClass, standardOnly);
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, final PsiClass aClass, HashMap<InterceptorMethodType, List<InterceptorMethod>> map, boolean separateClass, boolean standardNamesOnly) {
        for (Map.Entry<InterceptorMethodType, List<InterceptorMethod>> entry : map.entrySet()) {
            List<InterceptorMethod> list = entry.getValue();
            for (InterceptorMethod method : list) {
                PsiMethod psiMethod;
                if (separateClass || aClass != (psiMethod = method.getMethod()).getContainingClass()) continue;
                String methodName = psiMethod.getName();
                if (standardNamesOnly || !methodName.startsWith("ejb")) continue;
                holder.registerProblem((PsiElement)psiMethod.getNameIdentifier(), EjbHighlightingMessages.message("method.name.conflict", methodName), new LocalQuickFix[0]);
            }
        }
        if (map.isEmpty() && separateClass) {
            holder.registerProblem((PsiElement)aClass.getNameIdentifier(), EjbHighlightingMessages.message("interceptor.class.has.no.annotated.methods", aClass.getName()), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = EjbHighlightingMessages.message("intention.family.generate.interceptor.methods", new Object[0]);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    Editor editor;
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (descriptor == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, aClass.getContainingFile().getVirtualFile(), aClass.getNameIdentifier().getTextOffset()), true)) != null) {
                        new GenerateInterceptorMethods().actionPerformedImpl(project, editor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

