/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfiguration;
import com.intellij.javaee.ejb.facet.EjbFacetConfigurationImpl;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.javaee.model.annotations.ejb.EjbRootElementImpl;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.merged.MergedEjbRootElement;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbFacetImpl
extends EjbFacet
implements JavaeeFacetEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.ejb.facet.EjbFacetImpl");
    private DomFileElement<EjbJar> myEjbModuleDescriptor;
    private EjbRootElementImpl myAnnotationsRootElement;
    private final JavaeeFacetCommonPart myCommonPart;

    public EjbFacetImpl(@NotNull EjbFacetType facetType, @NotNull Module module, String name, @NotNull EjbFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            EjbFacetImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            EjbFacetImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            EjbFacetImpl.$$$reportNull$$$0(2);
        }
        super((FacetType)facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)facetType.getDescriptorsMetaDataProvider(), configuration.getDescriptorsConfiguration());
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    @Override
    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    @Override
    public void onFacetChanged() {
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    @Nullable
    public final EjbJar getXmlRoot() {
        this.refreshModelRoot();
        return this.myEjbModuleDescriptor == null ? null : (EjbJar)this.myEjbModuleDescriptor.getRootElement();
    }

    public final XmlFile getXmlDescriptor() {
        return this.myEjbModuleDescriptor.getFile();
    }

    @Nullable
    public EjbRootElement getAnnotationRoot() {
        this.refreshModelRoot();
        return this.myAnnotationsRootElement;
    }

    private void refreshModelRoot() {
        ConfigFile descriptor = this.getEjbJarDescriptor();
        XmlFile xmlFile = descriptor == null ? null : descriptor.getXmlFile();
        EjbJar xmlRoot = (EjbJar)JamCommonUtil.getRootElement((PsiFile)xmlFile, EjbJar.class, (Module)this.getModule());
        boolean annoEnabled = EjbFacetImpl.shouldCreateAnnotationRoot(xmlRoot);
        if (this.myAnnotationsRootElement == null && annoEnabled) {
            this.myAnnotationsRootElement = new EjbRootElementImpl(this);
        } else if (this.myAnnotationsRootElement != null && !annoEnabled) {
            this.myAnnotationsRootElement = null;
        }
        this.myEjbModuleDescriptor = xmlRoot == null ? null : (DomFileElement)xmlRoot.getParent();
    }

    private static boolean shouldCreateAnnotationRoot(EjbJar ejbJar) {
        EjbDescriptorVersion ejbVersion;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return ejbJar == null || !ejbJar.isValid() || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)(ejbVersion = EjbUtil.getEjbJarVersion(DomService.getInstance().getContainingFile((DomElement)ejbJar)))) <= 0 && !Boolean.TRUE.equals(ejbJar.getMetadataComplete().getValue());
    }

    public void initFacet() {
        this.myCommonPart.initFacet();
        JavaeeUtil.installDomAndJamListeners((Facet)this, this.getCommonPart().getDescriptorsContainer());
    }

    @NotNull
    public final EjbRootElement getMergedRoot() {
        this.refreshModelRoot();
        if (this.myEjbModuleDescriptor != null) {
            EjbJar ejbJar = (EjbJar)this.myEjbModuleDescriptor.getRootElement();
            if (this.myAnnotationsRootElement == null || Boolean.TRUE.equals(ejbJar.getMetadataComplete().getValue())) {
                EjbJar ejbJar2 = ejbJar;
                if (ejbJar2 == null) {
                    EjbFacetImpl.$$$reportNull$$$0(3);
                }
                return ejbJar2;
            }
            MergedEjbRootElement mergedEjbRootElement = new MergedEjbRootElement(this, new EjbRootElement[]{this.myAnnotationsRootElement, ejbJar});
            if (mergedEjbRootElement == null) {
                EjbFacetImpl.$$$reportNull$$$0(4);
            }
            return mergedEjbRootElement;
        }
        if (this.myAnnotationsRootElement != null) {
            EjbRootElementImpl ejbRootElementImpl = this.myAnnotationsRootElement;
            if (ejbRootElementImpl == null) {
                EjbFacetImpl.$$$reportNull$$$0(5);
            }
            return ejbRootElementImpl;
        }
        MergedEjbRootElement mergedEjbRootElement = new MergedEjbRootElement(this, new EjbRootElement[0]);
        if (mergedEjbRootElement == null) {
            EjbFacetImpl.$$$reportNull$$$0(6);
        }
        return mergedEjbRootElement;
    }

    @Nullable
    public ConfigFile getEjbJarDescriptor() {
        return this.getDescriptorsContainer().getConfigFile(EjbRootDescriptor.EJB_JAR_META_DATA);
    }

    public Collection<VirtualFile> getSourceRoots() {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        for (String url : this.getConfigurationImpl().getSourceRoots()) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            list.add(file);
        }
        return list;
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        Collection<VirtualFile> roots = this.myCommonPart.getDescriptors();
        roots.addAll(this.getSourceRoots());
        Collection<VirtualFile> collection = roots;
        if (collection == null) {
            EjbFacetImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public void addEjbSourceRoot(@NotNull String url) {
        if (url == null) {
            EjbFacetImpl.$$$reportNull$$$0(8);
        }
        String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls();
        LOG.assertTrue(Arrays.asList(sourceRoots).contains(url), (Object)("'" + url + "' is not a source root"));
        List<String> urls = this.getConfigurationImpl().getSourceRoots();
        LOG.assertTrue(!urls.contains(url), (Object)("'" + url + "' is already registered"));
        urls.add(url);
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public void removeEjbSourceRoot(@NotNull String url) {
        if (url == null) {
            EjbFacetImpl.$$$reportNull$$$0(9);
        }
        List<String> sourceRoots = this.getConfigurationImpl().getSourceRoots();
        boolean removed = sourceRoots.remove(url);
        LOG.assertTrue(removed, (Object)("Ejb source root '" + url + "' not found."));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public List<String> getEjbSourceRootUrls() {
        return Collections.unmodifiableList(this.getConfigurationImpl().getSourceRoots());
    }

    public void setEjbSourceRoots(@NotNull @NonNls String[] urls) {
        if (urls == null) {
            EjbFacetImpl.$$$reportNull$$$0(10);
        }
        this.getConfigurationImpl().setSourceRoots(new ArrayList<String>(Arrays.asList(urls)));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    @NotNull
    public String[] getEjbSourceRoots() {
        List<String> roots = this.getConfigurationImpl().getSourceRoots();
        String[] stringArray = ArrayUtil.toStringArray(roots);
        if (stringArray == null) {
            EjbFacetImpl.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private EjbFacetConfigurationImpl getConfigurationImpl() {
        return (EjbFacetConfigurationImpl)this.getConfiguration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/facet/EjbFacetImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/facet/EjbFacetImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEjbSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addEjbSourceRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeEjbSourceRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEjbSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

