/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment.ui.actions;

import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ui.DeploymentSettingsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import java.util.Collections;
import java.util.List;

public class AddArtifactToDeployActionRunnable
implements AnActionButtonRunnable {
    private final DeploymentSettingsPanel myPanel;

    public AddArtifactToDeployActionRunnable(DeploymentSettingsPanel panel) {
        this.myPanel = panel;
    }

    public void run(AnActionButton anActionButton) {
        this.run();
    }

    public void run() {
        Project project = this.myPanel.getProject();
        List<Artifact> supportedArtifacts = this.getAvailableArtifacts();
        if (supportedArtifacts.size() == 1) {
            this.addArtifact(project, supportedArtifacts.get(0));
            return;
        }
        ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(project, supportedArtifacts, "Select Artifacts to Deploy", "Selected artifacts will be deployed at server startup");
        if (dialog.showAndGet()) {
            List chosen = dialog.getChosenElements();
            for (Artifact artifact : chosen) {
                this.addArtifact(project, artifact);
            }
        }
    }

    private void addArtifact(Project project, Artifact artifact) {
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)project).createPointer(artifact);
        this.myPanel.addDeploymentModel((DeploymentSource)JavaeeDeploymentUtil.getInstance().createArtifactDeploymentSource(pointer));
    }

    public List<Artifact> getAvailableArtifacts() {
        Project project = this.myPanel.getProject();
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)project);
        List supportedArtifacts = deploymentManager.getSupportedArtifacts(this.myPanel.getDeploymentProvider());
        supportedArtifacts.removeAll(this.myPanel.getAddedArtifacts());
        return supportedArtifacts;
    }
}

