/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.PerformAdapter;
import com.intellij.javaee.deployment.UpdateAdapter;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.util.List;

public class UndeployAction
extends AnAction {
    public UndeployAction() {
        super(J2EEBundle.message((String)"action.name.undeploy", (Object[])new Object[0]), "", AllIcons.Nodes.Undeploy);
    }

    public void update(AnActionEvent e) {
        new UpdateAdapter(){

            @Override
            protected boolean doUpdate(AnActionEvent event, J2EEServerInstance serverInstance, CommonModel commonModel, Project project, List<DeploymentModel> deploymentModels) {
                if (!super.doUpdate(event, serverInstance, commonModel, project, deploymentModels)) {
                    return false;
                }
                if (deploymentModels.isEmpty()) {
                    return false;
                }
                DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)project);
                for (DeploymentModel deploymentModel : deploymentModels) {
                    DeploymentStatus status = deploymentManager.getDeploymentStatus(deploymentModel, commonModel);
                    if (status == DeploymentStatus.UNKNOWN || status == DeploymentStatus.DEPLOYED) continue;
                    return false;
                }
                return true;
            }
        }.processAction(e);
    }

    public void actionPerformed(AnActionEvent e) {
        new PerformAdapter(){

            @Override
            protected void doPerform(AnActionEvent event, J2EEServerInstance serverInstance, CommonModel commonModel, Project project, List<DeploymentModel> deploymentModels) {
                try {
                    for (DeploymentModel deploymentModel : deploymentModels) {
                        ((CommonStrategy)commonModel).getDeploymentProvider().startUndeploy(serverInstance, deploymentModel);
                    }
                }
                catch (Exception e1) {
                    serverInstance.registerServerError((Throwable)e1);
                }
            }
        }.processAction(e);
    }
}

