/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.deployment.DeploymentActionAdapter;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.UpdateAdapter;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import java.util.List;

public class KeepDeployedAfterDisconnectAction
extends ToggleAction {
    public KeepDeployedAfterDisconnectAction() {
        super("Leave artifact deployed after disconnect", null, AllIcons.Actions.Forward);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        final Ref visible = new Ref((Object)false);
        new UpdateAdapter(){

            @Override
            protected boolean doUpdate(AnActionEvent event, J2EEServerInstance serverInstance, CommonModel commonModel, Project project, List<DeploymentModel> deploymentModels) {
                visible.set((Object)((CommonStrategy)commonModel).getDeploymentProvider().isNeedUndeployOnDisconnect());
                return super.doUpdate(event, serverInstance, commonModel, project, deploymentModels);
            }
        }.processAction(e);
        e.getPresentation().setVisible(((Boolean)visible.get()).booleanValue());
    }

    public boolean isSelected(AnActionEvent e) {
        final Ref result = new Ref((Object)false);
        new DeploymentActionAdapter(){

            @Override
            protected void doProcessAction(AnActionEvent event, J2EEServerInstance serverInstance, CommonModel commonModel, Project project, List<DeploymentModel> deploymentModels) {
                if (deploymentModels.isEmpty()) {
                    return;
                }
                DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)project);
                for (DeploymentModel deploymentModel : deploymentModels) {
                    if (deploymentManager.isKeepDeployedAfterDisconnect(deploymentModel, commonModel)) continue;
                    return;
                }
                result.set((Object)true);
            }
        }.processAction(e);
        return (Boolean)result.get();
    }

    public void setSelected(AnActionEvent e, final boolean state) {
        new DeploymentActionAdapter(){

            @Override
            protected void doProcessAction(AnActionEvent event, J2EEServerInstance serverInstance, CommonModel commonModel, Project project, List<DeploymentModel> deploymentModels) {
                DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)project);
                for (DeploymentModel deploymentModel : deploymentModels) {
                    deploymentManager.setKeepDeployedAfterDisconnect(deploymentModel, commonModel, state);
                }
            }
        }.processAction(e);
    }
}

