/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.deployment.ExternalFileDeploymentProviderImpl;
import com.intellij.javaee.deployment.ExternalFileDeploymentSource;
import com.intellij.javaee.deployment.JavaeeArtifactDeploymentSourceImpl;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ModuleDeploymentSource;
import com.intellij.javaee.deployment.ModuleDeploymentSourceImpl;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactType;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JavaeeDeploymentUtilImpl
extends JavaeeDeploymentUtil {
    @NotNull
    public ArtifactDeploymentSource createArtifactDeploymentSource(@NotNull ArtifactPointer artifactPointer) {
        if (artifactPointer == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(0);
        }
        JavaeeArtifactDeploymentSourceImpl javaeeArtifactDeploymentSourceImpl = new JavaeeArtifactDeploymentSourceImpl(artifactPointer);
        if (javaeeArtifactDeploymentSourceImpl == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(1);
        }
        return javaeeArtifactDeploymentSourceImpl;
    }

    @NotNull
    public DeploymentSource createExternalFileDeploymentSource(@NotNull File file) {
        if (file == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(2);
        }
        ExternalFileDeploymentSource externalFileDeploymentSource = new ExternalFileDeploymentSource(file);
        if (externalFileDeploymentSource == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(3);
        }
        return externalFileDeploymentSource;
    }

    @NotNull
    public ModuleDeploymentSource createModuleDeploymentSource(@NotNull ModulePointer modulePointer) {
        if (modulePointer == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(4);
        }
        ModuleDeploymentSourceImpl moduleDeploymentSourceImpl = new ModuleDeploymentSourceImpl(modulePointer);
        if (moduleDeploymentSourceImpl == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(5);
        }
        return moduleDeploymentSourceImpl;
    }

    @NotNull
    public ExternalFileDeploymentProvider createExternalFileDeploymentProvider(@NotNull Collection<? extends ArtifactType> artifactTypes) {
        if (artifactTypes == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(6);
        }
        boolean directoriesAllowed = false;
        HashSet<String> allowedExtensions = new HashSet<String>();
        JavaeeArtifactUtil artifactUtil = JavaeeArtifactUtil.getInstance();
        for (ArtifactType artifactType : artifactTypes) {
            if (!artifactUtil.isArchive(artifactType)) {
                directoriesAllowed = true;
                continue;
            }
            if (artifactUtil.isEjbApplication(artifactType)) {
                allowedExtensions.add("jar");
                continue;
            }
            if (artifactUtil.isJavaeeApplication(artifactType)) {
                allowedExtensions.add("ear");
                continue;
            }
            if (!WebArtifactUtil.getInstance().isWebApplication(artifactType)) continue;
            allowedExtensions.add("war");
        }
        ExternalFileDeploymentProviderImpl externalFileDeploymentProviderImpl = new ExternalFileDeploymentProviderImpl(directoriesAllowed, allowedExtensions);
        if (externalFileDeploymentProviderImpl == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(7);
        }
        return externalFileDeploymentProviderImpl;
    }

    @NotNull
    public ExternalFileDeploymentProvider createExternalFileDeploymentProvider(boolean directoriesAllowed, String ... allowedExtensions) {
        ExternalFileDeploymentProviderImpl externalFileDeploymentProviderImpl = new ExternalFileDeploymentProviderImpl(directoriesAllowed, Arrays.asList(allowedExtensions));
        if (externalFileDeploymentProviderImpl == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(8);
        }
        return externalFileDeploymentProviderImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePointer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/deployment/JavaeeDeploymentUtilImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactDeploymentSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalFileDeploymentSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleDeploymentSource";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalFileDeploymentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactDeploymentSource";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createExternalFileDeploymentSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDeploymentSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExternalFileDeploymentProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

