/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class PackagingMethod {
    private final String myId;
    private final String myDescription;
    private static final Map<String, PackagingMethod> ourRegisteredMethods = new THashMap();
    public static final PackagingMethod DO_NOT_PACKAGE = new PackagingMethod("0", "Do not package");
    public static final PackagingMethod COPY_FILES = new PackagingMethod("1", "Copy files");
    public static final PackagingMethod COPY_FILES_AND_LINK_VIA_MANIFEST = new PackagingMethod("2", "Copy files and link via manifest");
    public static final PackagingMethod INCLUDE_MODULE_IN_BUILD = new PackagingMethod("4", "Include module in build");
    public static final PackagingMethod JAR_AND_COPY_FILE = new PackagingMethod("5", "JAR and copy file");
    public static final PackagingMethod JAR_AND_COPY_FILE_AND_LINK_VIA_MANIFEST = new PackagingMethod("6", "JAR, copy and link via manifest");

    private PackagingMethod(@NonNls String id, @NonNls String description) {
        this.myId = id;
        this.myDescription = description;
        ourRegisteredMethods.put(id, this);
    }

    public String getId() {
        return this.myId;
    }

    public static PackagingMethod getDeploymentMethodById(String id) {
        return ourRegisteredMethods.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackagingMethod)) {
            return false;
        }
        PackagingMethod method = (PackagingMethod)o;
        return this.myId.equals(method.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return this.myDescription;
    }
}

