/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.javaee.converting.artifacts.JavaeePackagingConverter;
import com.intellij.javaee.run.configuration.DeploymentSettingsImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class JavaeeRunConfigurationsConverter
extends ConversionProcessor<RunManagerSettings> {
    @NonNls
    private static final String DEPLOY_OPTION = "DEPLOY";
    private final JavaeePackagingConverter myConverter;

    public JavaeeRunConfigurationsConverter(JavaeePackagingConverter converter) {
        this.myConverter = converter;
    }

    public boolean isConversionNeeded(RunManagerSettings runManagerSettings) {
        for (Element configuration : runManagerSettings.getRunConfigurations()) {
            if (configuration.getChildren("JAVAEE_FACET").isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void process(RunManagerSettings runManagerSettings) throws CannotConvertException {
        for (Element configuration : runManagerSettings.getRunConfigurations()) {
            this.convertRunConfiguration(configuration);
        }
    }

    private void convertRunConfiguration(Element configuration) {
        List elements = JDOMUtil.getChildren((Element)configuration, (String)"JAVAEE_FACET");
        if (elements.isEmpty()) {
            return;
        }
        ArrayList<String> artifactsToDeploy = new ArrayList<String>();
        DeploymentSettingsImpl.DeploymentSettingsState deploymentState = new DeploymentSettingsImpl.DeploymentSettingsState();
        for (Element element : elements) {
            if (!Boolean.parseBoolean(JDomConvertingUtil.getOptionValue((Element)element, (String)DEPLOY_OPTION))) continue;
            DeploymentSettingsImpl.ArtifactDeploymentSettingsState state = new DeploymentSettingsImpl.ArtifactDeploymentSettingsState();
            String facetId = element.getAttributeValue("FACET_ID");
            String deploymentSource = element.getAttributeValue("DEPLOYMENT_SOURCE_NAME");
            String artifactName = JavaeePackagingConverter.getArtifactName(facetId, "exploded".equals(deploymentSource));
            artifactsToDeploy.add(artifactName);
            state.myArtifactName = artifactName;
            Element settings = new Element("settings");
            JDomConvertingUtil.copyAttributes((Element)element, (Element)settings);
            settings.removeAttribute("DEPLOYMENT_SOURCE_NAME");
            settings.removeAttribute("FACET_ID");
            JDomConvertingUtil.copyChildren((Element)element, (Element)settings);
            JDomConvertingUtil.removeChildren((Element)settings, (Condition)JDomConvertingUtil.createOptionElementFilter((String)DEPLOY_OPTION));
            state.setSettings(settings);
            deploymentState.getDeploymentItems().add(state);
        }
        if (!artifactsToDeploy.isEmpty()) {
            Element buildArtifactsOption;
            Element methodElement = configuration.getChild("method");
            if (methodElement == null) {
                methodElement = new Element("method");
                configuration.addContent(methodElement);
            }
            if ((buildArtifactsOption = JDomConvertingUtil.findChild((Element)methodElement, (Condition)JDomConvertingUtil.createOptionElementFilter((String)"BuildArtifacts"))) == null) {
                buildArtifactsOption = JDomConvertingUtil.createOptionElement((String)"BuildArtifacts", (String)"true");
                methodElement.addContent(buildArtifactsOption);
            }
            buildArtifactsOption.setAttribute("enabled", "true");
            for (String artifactName : artifactsToDeploy) {
                Element artifactElement = new Element("artifact");
                artifactElement.setAttribute("name", artifactName);
                buildArtifactsOption.addContent(artifactElement);
            }
        }
        configuration.removeChildren("JAVAEE_FACET");
        configuration.removeChild("deployment");
        configuration.addContent(XmlSerializer.serialize((Object)deploymentState, (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
    }
}

