/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting;

import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.javaee.converting.JavaeeConvertingContext;
import com.intellij.openapi.util.Condition;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class JavaeeRunConfigurationConvertingUtil {
    @NonNls
    private static final String J2EE_MODULE_ELEMENT = "J2EE_MODULE";
    @NonNls
    private static final String MODULE_NAME_ATTRIBUTE = "MODULE_NAME";

    private JavaeeRunConfigurationConvertingUtil() {
    }

    private static void convertDeploymentModelElement(Element element, JavaeeConvertingContext context) {
        element.setName("JAVAEE_FACET");
        String moduleName = JDomConvertingUtil.getOptionValue((Element)element, (String)MODULE_NAME_ATTRIBUTE);
        String facetId = context.getFacetId(moduleName, true);
        element.setAttribute("FACET_ID", facetId);
        JDomConvertingUtil.removeChildren((Element)element, (Condition)JDomConvertingUtil.createOptionElementFilter((String)MODULE_NAME_ATTRIBUTE));
    }

    public static void convertRunConfiguration(Element runConfig, JavaeeConvertingContext context) {
        List list = runConfig.getChildren(J2EE_MODULE_ELEMENT);
        for (Element e : list) {
            JavaeeRunConfigurationConvertingUtil.convertDeploymentModelElement(e, context);
        }
    }

    public static boolean isConversionNeeded(Element runConfig) {
        return !runConfig.getChildren(J2EE_MODULE_ELEMENT).isEmpty();
    }
}

