/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EjbClassInheritorsSearcher {
    private EjbClassInheritorsSearcher() {
    }

    private static boolean processImplementations(PsiClass aClass, Processor<PsiClass> consumer) {
        EjbClassRole[] classRoles = (EjbClassRole[])ReadAction.compute(() -> OldEjbRolesUtil.getEjbRoles(aClass));
        if (classRoles.length == 0) {
            return true;
        }
        HashSet visited = ContainerUtil.newHashSet();
        for (EjbClassRole classRole : classRoles) {
            boolean processed;
            if (classRole == null || !classRole.isDeclarationRole() || (processed = ((Boolean)ReadAction.compute(() -> {
                for (PsiClass candidate : classRole.findImplementations()) {
                    if (candidate.isInheritor(aClass, true) || !visited.add(candidate) || consumer.process((Object)candidate)) continue;
                    return false;
                }
                return true;
            })).booleanValue())) continue;
            return false;
        }
        return true;
    }

    public static class ClassInheritorsSearcher
    implements QueryExecutor<PsiClass, ClassInheritorsSearch.SearchParameters> {
        public boolean execute(@NotNull ClassInheritorsSearch.SearchParameters p, @NotNull Processor<PsiClass> consumer) {
            if (p == null) {
                ClassInheritorsSearcher.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                ClassInheritorsSearcher.$$$reportNull$$$0(1);
            }
            return EjbClassInheritorsSearcher.processImplementations(p.getClassToProcess(), (Processor<PsiClass>)consumer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javaee/EjbClassInheritorsSearcher$ClassInheritorsSearcher";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DirectInheritorsSearcher
    implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
        public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters p, @NotNull Processor<PsiClass> consumer) {
            if (p == null) {
                DirectInheritorsSearcher.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DirectInheritorsSearcher.$$$reportNull$$$0(1);
            }
            return EjbClassInheritorsSearcher.processImplementations(p.getClassToProcess(), (Processor<PsiClass>)consumer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javaee/EjbClassInheritorsSearcher$DirectInheritorsSearcher";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

