/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.InterceptorMethodType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class GenerateInterceptorMethodsHandler
extends GenerateMembersHandlerBase {
    public GenerateInterceptorMethodsHandler() {
        super(J2EEBundle.message((String)"title.choose.interceptor.method.types", (Object[])new Object[0]));
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        boolean ejbClassMode = false;
        boolean standardNames = false;
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(aClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            ejbClassMode = true;
            standardNames = EjbUtil.implementsStandardEjbInterface(role.getEnterpriseBean());
        }
        PsiClass copy = (PsiClass)aClass.copy();
        ArrayList<PsiMethodMember> result = new ArrayList<PsiMethodMember>();
        for (InterceptorMethodType methodType : InterceptorMethodType.values()) {
            GenerateInterceptorMethodsHandler.addInterceptorMethod(result, copy, methodType, !ejbClassMode, standardNames);
        }
        return result.toArray(new ClassMember[result.size()]);
    }

    public static void addInterceptorMethod(ArrayList<PsiMethodMember> result, PsiClass aClass, InterceptorMethodType methodType, boolean separateClass, boolean standardNames) {
        block3: {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                PsiAnnotation psiAnnotation = psiMethod.getModifierList().findAnnotation(methodType.getMethodAnnotation());
                if (psiAnnotation == null) continue;
                return;
            }
            PsiMethod psiMethod = GenerateInterceptorMethodsHandler.generateInterceptorMethod(aClass, methodType, separateClass, standardNames);
            try {
                result.add(new PsiMethodMember((PsiMethod)aClass.add((PsiElement)psiMethod)));
            }
            catch (IncorrectOperationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static PsiMethod generateInterceptorMethod(PsiClass aClass, InterceptorMethodType methodType, boolean separateClass, boolean standardNames) {
        String methodName;
        String annotationName = methodType.getMethodAnnotation();
        String string = methodName = standardNames ? methodType.getMethodStandardName() : StringUtil.decapitalize((String)methodType.getTypeName());
        String methodText = methodType == InterceptorMethodType.AROUND_INVOKE ? "@" + annotationName + " public Object " + methodName + "(" + "javax.interceptor.InvocationContext" + " context) throws Exception { return context.proceed(); }" : (separateClass ? "@" + annotationName + " void " + methodName + "(" + "javax.interceptor.InvocationContext" + " context) { try { context.proceed(); } catch (Exception e) { e.printStackTrace(); } }" : "@" + annotationName + " void " + methodName + "() { }");
        try {
            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createMethodFromText(methodText, null);
        }
        catch (IncorrectOperationException e) {
            assert (false) : e;
            return null;
        }
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        return new GenerationInfo[]{new PsiGenerationInfo((PsiMember)((PsiMethodMember)originalMember).getElement())};
    }
}

