/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeStyleJ2EENamesPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleJ2EENamesPanel");
    private Map<String, JTextField> myControls;
    @NonNls
    private static final String[][] myEBSettings = new String[][]{{J2EEBundle.message((String)"editbox.j2eenames.ejb.class", (Object[])new Object[0]), "ENTITY_EB_PREFIX", "ENTITY_EB_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.home.interface", (Object[])new Object[0]), "ENTITY_HI_PREFIX", "ENTITY_HI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.remote.interface", (Object[])new Object[0]), "ENTITY_RI_PREFIX", "ENTITY_RI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.local.home.interface", (Object[])new Object[0]), "ENTITY_LHI_PREFIX", "ENTITY_LHI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.local.interface", (Object[])new Object[0]), "ENTITY_LI_PREFIX", "ENTITY_LI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.ejb.name.tag", (Object[])new Object[0]), "ENTITY_DD_PREFIX", "ENTITY_DD_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.transfer.object", (Object[])new Object[0]), "ENTITY_VO_PREFIX", "ENTITY_VO_SUFFIX"}};
    @NonNls
    private static final String[][] mySBSettings = new String[][]{{J2EEBundle.message((String)"editbox.j2eenames.ejb.class", (Object[])new Object[0]), "SESSION_EB_PREFIX", "SESSION_EB_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.home.interface", (Object[])new Object[0]), "SESSION_HI_PREFIX", "SESSION_HI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.remote.interface", (Object[])new Object[0]), "SESSION_RI_PREFIX", "SESSION_RI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.local.home.interface", (Object[])new Object[0]), "SESSION_LHI_PREFIX", "SESSION_LHI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.local.interface", (Object[])new Object[0]), "SESSION_LI_PREFIX", "SESSION_LI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.service.endpoint.interface", (Object[])new Object[0]), "SESSION_SI_PREFIX", "SESSION_SI_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.ejb.name.tag", (Object[])new Object[0]), "SESSION_DD_PREFIX", "SESSION_DD_SUFFIX"}};
    @NonNls
    private static final String[][] myMBSettings = new String[][]{{J2EEBundle.message((String)"editbox.j2eenames.ejb.class", (Object[])new Object[0]), "MESSAGE_EB_PREFIX", "MESSAGE_EB_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.ejb.name.tag", (Object[])new Object[0]), "MESSAGE_DD_PREFIX", "MESSAGE_DD_SUFFIX"}};
    @NonNls
    private static final String[][] myServletSettings = new String[][]{{J2EEBundle.message((String)"editbox.j2eenames.servlet.class", (Object[])new Object[0]), "SERVLET_CLASS_PREFIX", "SERVLET_CLASS_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.servlet.name.tag", (Object[])new Object[0]), "SERVLET_DD_PREFIX", "SERVLET_DD_SUFFIX"}};
    @NonNls
    private static final String[][] myFilterSettings = new String[][]{{J2EEBundle.message((String)"editbox.j2eenames.filter.class", (Object[])new Object[0]), "FILTER_CLASS_PREFIX", "FILTER_CLASS_SUFFIX"}, {J2EEBundle.message((String)"editbox.j2eenames.filter.name.tag", (Object[])new Object[0]), "FILTER_DD_PREFIX", "FILTER_DD_SUFFIX"}};
    @NonNls
    private static final String[][] myListenerSettings = new String[][]{{J2EEBundle.message((String)"editbox.j2eenames.listener.class", (Object[])new Object[0]), "LISTENER_CLASS_PREFIX", "LISTENER_CLASS_SUFFIX"}};
    private final JavaeeCodeStyleSettings mySettings;

    public CodeStyleJ2EENamesPanel(JavaeeCodeStyleSettings settings) {
        this.mySettings = settings;
        this.setLayout(new BorderLayout());
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.createPanel(), (boolean)true), "Center");
        this.reset(this.mySettings);
    }

    private static JPanel createEntityBeanPanel(Map<String, JTextField> ctl) {
        JPanel panel = CodeStyleJ2EENamesPanel.createSuffixPrefixTable(J2EEBundle.message((String)"title.entity.bean", (Object[])new Object[0]), myEBSettings, ctl);
        panel.remove(panel.getComponentCount() - 1);
        GridBagConstraints gb = new GridBagConstraints();
        gb.fill = 2;
        gb.anchor = 17;
        gb.insets = JBUI.insets((int)0, (int)2, (int)2, (int)2);
        gb.gridy = myEBSettings.length + 1;
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        JLabel label = new JLabel(J2EEBundle.message((String)"editbox.default.pk.class", (Object[])new Object[0]));
        label.setHorizontalAlignment(4);
        panel.add((Component)label, gb);
        ++gb.gridx;
        gb.gridwidth = 2;
        gb.weightx = 0.0;
        JTextField text = new JTextField();
        panel.add((Component)text, gb);
        ctl.put("ENTITY_PK_CLASS", text);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 3;
        gb.weighty = 1.0;
        gb.fill = 1;
        panel.add((Component)new JPanel(), gb);
        return panel;
    }

    private static JPanel createSuffixPrefixTable(String title, String[][] settings, Map<String, JTextField> ctl) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.fill = 2;
        gb.anchor = 17;
        gb.insets = JBUI.insets((int)0, (int)2, (int)2, (int)2);
        gb.gridy = 0;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weighty = 0.0;
        gb.gridx = 1;
        panel.add((Component)new JLabel(J2EEBundle.message((String)"label.prefix", (Object[])new Object[0])), gb);
        gb.gridx = 2;
        panel.add((Component)new JLabel(J2EEBundle.message((String)"label.suffix", (Object[])new Object[0])), gb);
        for (String[] row : settings) {
            gb.gridx = 0;
            gb.weightx = 0.0;
            ++gb.gridy;
            JLabel label = new JLabel(row[0] + ": ");
            label.setHorizontalAlignment(4);
            panel.add((Component)label, gb);
            gb.weightx = 1.0;
            ++gb.gridx;
            JTextField prefix = new JTextField(8);
            panel.add((Component)prefix, gb);
            ctl.put(row[1], prefix);
            ++gb.gridx;
            JTextField suffix = new JTextField(8);
            panel.add((Component)suffix, gb);
            ctl.put(row[2], suffix);
        }
        gb.insets = JBUI.emptyInsets();
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 3;
        gb.weighty = 1.0;
        gb.fill = 1;
        panel.add((Component)new JPanel(), gb);
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)true));
        return panel;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.fill = 1;
        gb.anchor = 18;
        gb.gridy = 0;
        gb.gridx = 0;
        gb.ipadx = 10;
        gb.ipady = 4;
        this.myControls = new HashMap();
        panel.add((Component)CodeStyleJ2EENamesPanel.createEntityBeanPanel(this.myControls), gb);
        gb.gridx = 1;
        gb.gridy = 0;
        panel.add((Component)CodeStyleJ2EENamesPanel.createSuffixPrefixTable(J2EEBundle.message((String)"label.j2eenames.session.bean", (Object[])new Object[0]), mySBSettings, this.myControls), gb);
        gb.gridx = 0;
        gb.gridy = 2;
        panel.add((Component)CodeStyleJ2EENamesPanel.createSuffixPrefixTable(J2EEBundle.message((String)"label.j2eenames.servlet", (Object[])new Object[0]), myServletSettings, this.myControls), gb);
        gb.gridx = 1;
        gb.gridy = 2;
        panel.add((Component)CodeStyleJ2EENamesPanel.createSuffixPrefixTable(J2EEBundle.message((String)"label.j2eenames.message.driven.bean", (Object[])new Object[0]), myMBSettings, this.myControls), gb);
        gb.gridx = 0;
        gb.gridy = 3;
        panel.add((Component)CodeStyleJ2EENamesPanel.createSuffixPrefixTable(J2EEBundle.message((String)"label.j2eenames.filter", (Object[])new Object[0]), myFilterSettings, this.myControls), gb);
        gb.gridx = 1;
        gb.gridy = 3;
        panel.add((Component)CodeStyleJ2EENamesPanel.createSuffixPrefixTable(J2EEBundle.message((String)"label.j2eenames.listener", (Object[])new Object[0]), myListenerSettings, this.myControls), gb);
        gb.gridx = 2;
        gb.gridy = 4;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        panel.add((Component)new JPanel(), gb);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        return panel;
    }

    public void reset(@NotNull JavaeeCodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleJ2EENamesPanel.$$$reportNull$$$0(0);
        }
        for (String name : this.myControls.keySet()) {
            this.readSetting(settings, name);
        }
    }

    public void apply(@NotNull JavaeeCodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleJ2EENamesPanel.$$$reportNull$$$0(1);
        }
        for (String name : this.myControls.keySet()) {
            this.saveSetting(settings, name);
        }
    }

    private void saveSetting(@NonNls JavaeeCodeStyleSettings settings, String name) {
        String value = this.getUserSetting(name);
        try {
            Field field = JavaeeCodeStyleSettings.class.getField(name);
            field.set(settings, value);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private String getUserSetting(String name) {
        JTextField fld = this.myControls.get(name);
        return fld.getText();
    }

    private void readSetting(@NotNull JavaeeCodeStyleSettings settings, String name) {
        if (settings == null) {
            CodeStyleJ2EENamesPanel.$$$reportNull$$$0(2);
        }
        JTextField fld = this.myControls.get(name);
        fld.setText(CodeStyleJ2EENamesPanel.getStoredSetting(settings, name));
    }

    private static String getStoredSetting(@NotNull JavaeeCodeStyleSettings settings, @NotNull String name) {
        if (settings == null) {
            CodeStyleJ2EENamesPanel.$$$reportNull$$$0(3);
        }
        if (name == null) {
            CodeStyleJ2EENamesPanel.$$$reportNull$$$0(4);
        }
        String value = null;
        try {
            Field field = JavaeeCodeStyleSettings.class.getField(name);
            value = (String)field.get(settings);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return value;
    }

    public boolean isModified() {
        for (String name : this.myControls.keySet()) {
            if (Comparing.equal((String)this.getUserSetting(name), (String)CodeStyleJ2EENamesPanel.getStoredSetting(this.mySettings, name), (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/CodeStyleJ2EENamesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readSetting";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStoredSetting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

