/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.SqliteDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.BasicDbPsiManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourceConfigurable;
import org.jetbrains.android.database.AndroidDataSourceStorage;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDbManager
extends BasicDbPsiManager<AndroidDataSource> {
    public static final String NOTIFICATION_GROUP_ID = "Android Data Source Manager";
    static final DataSourceTemplate DEFAULT_TEMPLATE = new AndroidDataSourceTemplate();

    public AndroidDbManager(@NotNull DbPsiFacade dbFacade) {
        if (dbFacade == null) {
            AndroidDbManager.$$$reportNull$$$0(0);
        }
        super(dbFacade, AndroidDataSourceStorage.getInstance(dbFacade.getProject()).getDataSources());
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull DbDataSource element) {
        if (element == null) {
            AndroidDbManager.$$$reportNull$$$0(1);
        }
        return SqliteDialect.INSTANCE;
    }

    @Nullable
    public SqlLanguageDialect getSqlDialect(@NotNull DbDataSource element) {
        if (element == null) {
            AndroidDbManager.$$$reportNull$$$0(2);
        }
        return DbSqlUtil.findSqlDialect((DatabaseDialect)SqliteDialect.INSTANCE);
    }

    public void setDataSourceName(@NotNull DbDataSource element, String name) {
        if (element == null) {
            AndroidDbManager.$$$reportNull$$$0(3);
        }
        if (!(element.getDelegate() instanceof AndroidDataSource)) {
            throw new UnsupportedOperationException();
        }
        AndroidDataSource dataSource = (AndroidDataSource)element.getDelegate();
        dataSource.setName(name);
        this.myDbFacade.clearCaches(element);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull DbElement element) {
        if (element == null) {
            AndroidDbManager.$$$reportNull$$$0(4);
        }
        AndroidDataSource androidDataSource = (AndroidDataSource)element.getDataSource().getDelegate();
        if (androidDataSource == null) {
            AndroidDbManager.$$$reportNull$$$0(5);
        }
        return androidDataSource;
    }

    public void removeDataSource(DbDataSource element) {
        if (!(element.getDelegate() instanceof AndroidDataSource)) {
            throw new UnsupportedOperationException();
        }
        AndroidDataSource dataSource = (AndroidDataSource)element.getDelegate();
        this.processAddOrRemove(dataSource, false);
    }

    @NotNull
    public Configurable createDataSourceEditor(DbDataSource template) {
        if (!(template.getDelegate() instanceof AndroidDataSource)) {
            throw new UnsupportedOperationException();
        }
        AndroidDataSource dataSource = (AndroidDataSource)template.getDelegate();
        AndroidDataSourceConfigurable androidDataSourceConfigurable = new AndroidDataSourceConfigurable(this, template.getProject(), dataSource);
        if (androidDataSourceConfigurable == null) {
            AndroidDbManager.$$$reportNull$$$0(6);
        }
        return androidDataSourceConfigurable;
    }

    @NotNull
    public List<DataSourceTemplate> getDataSourceTemplates() {
        if (ProjectFacetManager.getInstance((Project)this.myDbFacade.getProject()).hasFacets(AndroidFacet.ID)) {
            List<DataSourceTemplate> list = Collections.singletonList(DEFAULT_TEMPLATE);
            if (list == null) {
                AndroidDbManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<DataSourceTemplate> list = Collections.emptyList();
        if (list == null) {
            AndroidDbManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public DataSourceTemplate getDataSourceTemplate(DbDataSource element) {
        return DEFAULT_TEMPLATE;
    }

    public void processAddOrRemove(final AndroidDataSource dataSource, final boolean add) {
        final Project project = this.myDbFacade.getProject();
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                if (add) {
                    AndroidDbManager.this.removeDataSourceInner(project, dataSource);
                } else {
                    AndroidDbManager.this.addDataSourceInner(project, dataSource);
                }
            }

            public void redo() throws UnexpectedUndoException {
                if (add) {
                    AndroidDbManager.this.addDataSourceInner(project, dataSource);
                } else {
                    AndroidDbManager.this.removeDataSourceInner(project, dataSource);
                }
            }
        };
        String commandName = add ? DatabaseMessages.message((String)"command.name.add.data.source", (Object[])new Object[0]) : DatabaseMessages.message((String)"command.name.remove.data.source", (Object[])new Object[0]);
        new WriteCommandAction(project, commandName, new PsiFile[0], (UndoableAction)action, project){
            final /* synthetic */ UndoableAction val$action;
            final /* synthetic */ Project val$project;
            {
                this.val$action = undoableAction;
                this.val$project = project;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.val$action.redo();
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed(this.val$action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/database/AndroidDbManager$2", "run"));
            }
        }.execute();
    }

    private void removeDataSourceInner(Project project, AndroidDataSource dataSource) {
        AndroidDataSourceStorage storage = AndroidDataSourceStorage.getInstance(project);
        storage.removeDataSource(dataSource);
        this.detachDataSource(dataSource);
        this.clearCaches(null);
    }

    private void addDataSourceInner(Project project, AndroidDataSource dataSource) {
        AndroidDataSourceStorage storage = AndroidDataSourceStorage.getInstance(project);
        storage.addDataSource(dataSource);
        this.attachDataSource(dataSource);
        this.clearCaches(null);
    }

    private void clearCaches(@Nullable DatabaseSystem info) {
        this.myDbFacade.clearCaches(info != null ? this.myDbFacade.findDataSource(info.getUniqueId()) : null);
    }

    public boolean canCreateDataSourceByFiles(Collection<VirtualFile> files) {
        return false;
    }

    @NotNull
    public Collection<DbDataSource> createDataSourceByFiles(Collection<VirtualFile> files) {
        List<DbDataSource> list = Collections.emptyList();
        if (list == null) {
            AndroidDbManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void fireDataSourceUpdated(DbDataSource element) {
    }

    public void addDataSource(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            AndroidDbManager.$$$reportNull$$$0(10);
        }
        this.processAddOrRemove(dataSource, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDbManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDbManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceTemplates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDataSourceName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AndroidDataSourceTemplate
    implements DataSourceTemplate {
        private AndroidDataSourceTemplate() {
        }

        @NotNull
        public String getName() {
            if ("Android SQLite" == null) {
                AndroidDataSourceTemplate.$$$reportNull$$$0(0);
            }
            return "Android SQLite";
        }

        @NotNull
        public String getFullName() {
            String string = this.getName();
            if (string == null) {
                AndroidDataSourceTemplate.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<DataSourceTemplate> getSubConfigurations() {
            List<DataSourceTemplate> list = Collections.emptyList();
            if (list == null) {
                AndroidDataSourceTemplate.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
            if (project == null) {
                AndroidDataSourceTemplate.$$$reportNull$$$0(3);
            }
            AndroidDataSource result = copyFrom instanceof AndroidDataSource ? ((AndroidDataSource)copyFrom).copy() : new AndroidDataSource();
            result.setName(StringUtil.notNullize((String)newName, (String)this.getName()));
            result.resolveDriver();
            AndroidDataSource androidDataSource = result;
            if (androidDataSource == null) {
                AndroidDataSourceTemplate.$$$reportNull$$$0(4);
            }
            return androidDataSource;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AndroidIcons.Android;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubConfigurations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/database/AndroidDbManager$AndroidDataSourceTemplate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDataSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDataSource";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

