/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.Nullable;

@State(name="SpringRepositoriesView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpringRepositoriesViewSettings
implements PersistentStateComponent<Settings> {
    private final MessageBus myMessageBus;
    private Settings mySettings = new Settings();
    public static final Topic<Listener> TOPIC = new Topic("Spring Repositories View settings", Listener.class);

    public void fireSettingsChanged(ChangeType changeType) {
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).settingsChanged(changeType);
    }

    public static SpringRepositoriesViewSettings getInstance(Project project) {
        return (SpringRepositoriesViewSettings)ServiceManager.getService((Project)project, SpringRepositoriesViewSettings.class);
    }

    public SpringRepositoriesViewSettings(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    @Nullable
    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(Settings settings) {
        XmlSerializerUtil.copyBean((Object)settings, (Object)this.mySettings);
    }

    public boolean isShowModules() {
        return this.mySettings.showModules;
    }

    public void setShowModules(boolean value) {
        this.mySettings.showModules = value;
    }

    public boolean isSearchInLibraries() {
        return this.mySettings.searchInLibraries;
    }

    public void setSearchInLibraries(boolean value) {
        this.mySettings.searchInLibraries = value;
    }

    public boolean isShowAllRepositoryMethods() {
        return this.mySettings.showAllRepositoryMethods;
    }

    public void setShowAllRepositoryMethods(boolean value) {
        this.mySettings.showAllRepositoryMethods = value;
    }

    public static class Settings {
        public boolean showModules = true;
        public boolean searchInLibraries = false;
        public boolean showAllRepositoryMethods = false;
    }

    public static enum ChangeType {
        FULL,
        UPDATE_LIST,
        UPDATE_DETAILS,
        REPLACE_CHILD_UPDATE;

    }

    public static interface Listener {
        public void settingsChanged(ChangeType var1);
    }
}

