/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.parser.domain;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.utils.PsiTypeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyPath
implements Iterable<PropertyPath> {
    private static final String DELIMITERS = "_\\.";
    private static final String ALL_UPPERCASE = "[A-Z0-9._$]+";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private final PsiType owningType;
    private final String name;
    private final PsiType type;
    private final boolean isCollection;
    private PropertyPath next;

    PropertyPath(@NotNull String name, @Nullable PsiType owningType, @NotNull List<PropertyPath> base) {
        if (name == null) {
            PropertyPath.$$$reportNull$$$0(0);
        }
        if (base == null) {
            PropertyPath.$$$reportNull$$$0(1);
        }
        String propertyName = name.matches(ALL_UPPERCASE) ? name : StringUtil.decapitalize((String)name);
        this.owningType = owningType;
        this.isCollection = false;
        this.type = PropertyPath.getActualType(owningType, propertyName);
        this.name = propertyName;
    }

    @Nullable
    private static PsiType getActualType(@Nullable PsiType psiType, String propertyName) {
        if (psiType instanceof PsiClassType) {
            PsiType genericType;
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return null;
            }
            PsiType type = PropertyPath.getActualType(propertyName, psiClass);
            if (PsiTypeUtil.getInstance((Project)psiClass.getProject()).isCollectionType(psiType) && (genericType = PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Collection", (int)0, (boolean)true)) != null) {
                return genericType;
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static PsiType getActualType(String propertyName, PsiClass psiClass) {
        PsiField field = PropertyUtilBase.findPropertyField((PsiClass)psiClass, (String)propertyName, (boolean)false);
        if (field != null) {
            return field.getType();
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        return getter != null ? PropertyUtilBase.getPropertyType((PsiMember)getter) : null;
    }

    @Nullable
    public PsiType getOwningType() {
        return this.owningType;
    }

    public String getSegment() {
        return this.name;
    }

    public PropertyPath getLeafProperty() {
        PropertyPath result = this;
        while (result.hasNext()) {
            result = result.next();
        }
        return result;
    }

    @Nullable
    public PsiType getType() {
        return this.type;
    }

    public PropertyPath next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getSegment() + "." + this.next().toDotPath();
        }
        return this.getSegment();
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyPath path = (PropertyPath)o;
        if (this.isCollection != path.isCollection) {
            return false;
        }
        if (this.owningType != null ? !this.owningType.equals(path.owningType) : path.owningType != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(path.name) : path.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(path.type) : path.type != null) {
            return false;
        }
        return !(this.next != null ? !this.next.equals(path.next) : path.next != null);
    }

    public int hashCode() {
        int result = this.owningType != null ? this.owningType.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.isCollection ? 1 : 0);
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        return result;
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            private PropertyPath current;
            {
                this.current = PropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public PropertyPath next() {
                PropertyPath result = this.current;
                this.current = this.current.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PropertyPath from(@NotNull String source, @Nullable PsiType type) {
        if (source == null) {
            PropertyPath.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)source)) {
            return PropertyPath.create("", type, new Stack<PropertyPath>());
        }
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher = SPLITTER.matcher("_" + source);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        PropertyPath result = null;
        Stack<PropertyPath> current = new Stack<PropertyPath>();
        while (parts.hasNext()) {
            if (result == null) {
                result = PropertyPath.create((String)parts.next(), type, current);
                current.push(result);
                continue;
            }
            current.push(PropertyPath.create((String)parts.next(), current));
        }
        return result;
    }

    private static PropertyPath create(String source, Stack<PropertyPath> base) {
        PropertyPath propertyPath;
        PropertyPath previous = base.peek();
        previous.next = propertyPath = PropertyPath.create(source, previous.type, base);
        return propertyPath;
    }

    private static PropertyPath create(String source, PsiType type, List<PropertyPath> base) {
        return PropertyPath.create(source, type, "", base);
    }

    private static PropertyPath create(String source, PsiType type, String addTail, List<PropertyPath> base) {
        PropertyPath path;
        PropertyPath current = new PropertyPath(source, type, base);
        if (current.getType() == null && (path = PropertyPath.getImplicitExpressionPropertyPath(source, type, addTail, base)) != null) {
            return path;
        }
        if (!base.isEmpty()) {
            base.get((int)(base.size() - 1)).next = current;
        }
        ArrayList<PropertyPath> newBase = new ArrayList<PropertyPath>(base);
        newBase.add(current);
        if (StringUtil.isNotEmpty((String)addTail)) {
            current.next = PropertyPath.create(addTail, current.type, newBase);
        }
        return current;
    }

    @Nullable
    private static PropertyPath getImplicitExpressionPropertyPath(String source, PsiType type, String addTail, List<PropertyPath> base) {
        String tail;
        int position;
        String head;
        PropertyPath path;
        Pattern pattern = Pattern.compile("\\p{Lu}+\\p{Ll}*$");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find() && matcher.start() != 0 && (path = PropertyPath.create(head = source.substring(0, position = matcher.start()), type, (tail = source.substring(position)) + addTail, base)).getType() != null) {
            return path;
        }
        return null;
    }

    public String toString() {
        return String.format("%s.%s", this.owningType.getCanonicalText(), this.toDotPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/commons/util/parser/domain/PropertyPath";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "from";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

