/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.model.highlighting.jam.AbstractSpringJavaConfigInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringDataRepositoriesInspection
extends AbstractSpringJavaConfigInspection {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
            List problemDescriptors = holder.getResults();
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(4);
        }
        if (!SpringDataUtil.hasSpringDataSupport(module.getProject())) {
            return;
        }
        super.checkJavaFile(javaFile, holder, isOnTheFly, module);
    }

    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(5);
        }
        if (!SpringDataUtil.isRepository(aClass)) {
            return;
        }
        this.checkRepositoryClass(aClass, holder, module);
        Pair<PsiClass, ? extends PsiType> typePair = SpringDataUtil.substituteRepositoryTypes(aClass);
        if (typePair != null) {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                if (!SpringDataUtil.isQueryMethod(psiMethod)) continue;
                this.checkRepositoryMethod(holder, aClass, psiMethod, module, typePair);
            }
        }
    }

    protected void checkRepositoryClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(8);
        }
    }

    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, PsiClass repositoryClass, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(9);
        }
        if (psiMethod == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(10);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(11);
        }
        if (typePair == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(12);
        }
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType, String ... classes) {
        for (String aClass : classes) {
            PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)aClass, (int)0, (boolean)false);
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkJavaFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

