/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.dialects;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.xml.ThymeleafDomDialect;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafDialects {
    private static Map<String, ThymeleafLanguage> dialects = ContainerUtil.newHashMap();
    private static Map<String, String[]> namespaces = ContainerUtil.newHashMap();

    public static ThymeleafDialect[] getDialects(@NotNull Project project) {
        if (project == null) {
            ThymeleafDialects.$$$reportNull$$$0(0);
        }
        HashSet dialects = ContainerUtil.newHashSet();
        ContainerUtil.addAllNotNull((Collection)dialects, ThymeleafDialects.getDomDialects(project));
        ContainerUtil.addAllNotNull((Collection)dialects, (Object[])Extensions.getExtensions(ThymeleafDialect.EP_NAME));
        return dialects.toArray(new ThymeleafDialect[dialects.size()]);
    }

    @NotNull
    private static Set<ThymeleafDialect> getDomDialects(@NotNull Project project) {
        if (project == null) {
            ThymeleafDialects.$$$reportNull$$$0(1);
        }
        if (DumbService.isDumb((Project)project)) {
            Set<ThymeleafDialect> set = Collections.emptySet();
            if (set == null) {
                ThymeleafDialects.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)DomService.getInstance().getFileElements(ThymeleafDomDialect.class, project, GlobalSearchScope.allScope((Project)project)), DomFileElement::getRootElement);
        if (set == null) {
            ThymeleafDialects.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Nullable
    public static ThymeleafLanguage getLanguage(@Nullable String dialectFQN) {
        return dialectFQN == null ? null : dialects.get(dialectFQN);
    }

    @Nullable
    public static String[] getNamespaces(@Nullable String dialectFQN) {
        return dialectFQN == null ? null : namespaces.get(dialectFQN);
    }

    public static Set<String> getImplicitNamespaces() {
        HashSet ns = ContainerUtil.newHashSet();
        for (Object[] objectArray : namespaces.values()) {
            ContainerUtil.addAllNotNull((Collection)ns, (Object[])objectArray);
        }
        return ns;
    }

    static {
        dialects.put("org.thymeleaf.extras.springsecurity3.dialect.SpringSecurityDialect", ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS);
        dialects.put("org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect", ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS);
        namespaces.put("org.thymeleaf.standard.StandardDialect", ThymeleafNamespaceConstants.THYMELEAF_URIS);
        namespaces.put("org.thymeleaf.spring3.dialect.SpringStandardDialect", ThymeleafNamespaceConstants.THYMELEAF_SPRING_URIS);
        namespaces.put("org.thymeleaf.spring4.dialect.SpringStandardDialect", ThymeleafNamespaceConstants.THYMELEAF_SPRING_URIS);
        namespaces.put("org.thymeleaf.extras.springsecurity3.dialect.SpringSecurityDialect", ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_3_URIS);
        namespaces.put("org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect", ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_4_URIS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/dialects/ThymeleafDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/dialects/ThymeleafDialects";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDialects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDomDialects";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

