/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.ManipulatorsRegistryImpl;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceModelBrowserImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PersistenceHelperImpl
extends PersistenceHelper {
    protected static Logger LOG = Logger.getInstance((String)"com.intellij.persistence.PersistenceHelperImpl");
    private final ManipulatorsRegistry myManipulatorsRegistry = new ManipulatorsRegistryImpl();

    @NotNull
    public ManipulatorsRegistry getManipulatorsRegistry() {
        ManipulatorsRegistry manipulatorsRegistry = this.myManipulatorsRegistry;
        if (manipulatorsRegistry == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(0);
        }
        return manipulatorsRegistry;
    }

    @NotNull
    public PersistenceModelBrowser createModelBrowser() {
        PersistenceModelBrowserImpl persistenceModelBrowserImpl = new PersistenceModelBrowserImpl();
        if (persistenceModelBrowserImpl == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(1);
        }
        return persistenceModelBrowserImpl;
    }

    public PersistenceModelBrowser getSharedModelBrowser() {
        return PersistenceModelBrowserImpl.INSTANCE;
    }

    public void runCompositeWriteCommandAction(final @NotNull Project project, final @NotNull String actionName, @NotNull Collection<PsiElement> affectedElements, final @NotNull Ref<ProgressIndicator> indicatorRef, final Runnable ... runnables) {
        if (project == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(2);
        }
        if (actionName == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(3);
        }
        if (affectedElements == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(4);
        }
        if (indicatorRef == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(5);
        }
        if (runnables == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(6);
        }
        if (runnables.length == 0) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(affectedElements)) {
            return;
        }
        final Ref commandRef = Ref.create(null);
        final CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        commandRef.set(commandProcessorEx.startCommand(project, actionName, (Object)actionName, UndoConfirmationPolicy.REQUEST_CONFIRMATION));
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, actionName, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicatorRef.set((Object)indicator);
                Ref ex = Ref.create(null);
                try {
                    PersistenceHelperImpl.runInner(project, indicator, runnables);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    Throwable reason = e.getCause() != null ? e.getCause() : e;
                    LOG.error(reason);
                    ex.set((Object)reason);
                }
                finally {
                    PersistenceHelperImpl.runInDispatchThread(() -> {
                        String message;
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (actionName == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        try {
                            FileDocumentManager.getInstance().saveAllDocuments();
                        }
                        finally {
                            commandProcessorEx.finishCommand(project, commandRef.get(), (Throwable)ex.get());
                        }
                        if (!ex.isNull() && StringUtil.isNotEmpty((String)(message = StringUtil.getMessage((Throwable)((Throwable)ex.get()))))) {
                            Messages.showMessageDialog((Project)project, (String)message, (String)actionName, (Icon)Messages.getErrorIcon());
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/persistence/PersistenceHelperImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void runInner(Project project, ProgressIndicator indicator, Runnable ... runnables) throws Exception {
        Ref throwableRef;
        block4: {
            throwableRef = Ref.create(null);
            try {
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                Runnable[] clone = (Runnable[])runnables.clone();
                int i = 0;
                while (i < runnables.length && throwableRef.isNull()) {
                    Thread.yield();
                    int index = i++;
                    indicator.setFraction((double)index * 1.0 / (double)runnables.length);
                    indicator.checkCanceled();
                    PersistenceHelperImpl.runInDispatchThread(() -> {
                        try {
                            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                            ApplicationManager.getApplication().runWriteAction(clone[index]);
                        }
                        catch (Exception e) {
                            if (throwableRef.isNull()) {
                                throwableRef.set((Object)e);
                            }
                        }
                        finally {
                            clone[index] = null;
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!throwableRef.isNull()) break block4;
                throwableRef.set((Object)e);
            }
        }
        if (!throwableRef.isNull()) {
            throw (Exception)throwableRef.get();
        }
    }

    private static void runInDispatchThread(Runnable runnable) {
        ApplicationManager.getApplication().invokeAndWait(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/PersistenceHelperImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedElements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulatorsRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelBrowser";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/PersistenceHelperImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runCompositeWriteCommandAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

